package com.example.sefinsa_app.ui.prestamos;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.ClipData;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.widget.LinearLayoutCompat;
import androidx.core.content.FileProvider;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.WorkManager;

import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.example.sefinsa_app.AvalesWorker;
import com.example.sefinsa_app.ClientesWorker;
import com.example.sefinsa_app.NetworkChangeReceiver;
import com.example.sefinsa_app.NetworkSpeedChecker;
import com.example.sefinsa_app.PagosWorker;
import com.example.sefinsa_app.PrestamosWorker;
import com.example.sefinsa_app.R;
import com.example.sefinsa_app.api.API;
import com.example.sefinsa_app.controllers.ConfiguracionSemanasController;
import com.example.sefinsa_app.controllers.PagoController;
import com.example.sefinsa_app.controllers.PoblacionController;
import com.example.sefinsa_app.controllers.RutaController;
import com.example.sefinsa_app.migrations.DatabaseHelper;
import com.example.sefinsa_app.models.ConfiguracionSemana;
import com.example.sefinsa_app.models.Grupo;
import com.example.sefinsa_app.models.Modalidad;
import com.example.sefinsa_app.models.Pago;
import com.example.sefinsa_app.models.PagosHechos;
import com.example.sefinsa_app.models.Poblacion;
import com.example.sefinsa_app.models.Prestamo;
import com.example.sefinsa_app.models.Ruta;
import com.example.sefinsa_app.utilities.BluetoothPrint;
import com.example.sefinsa_app.utilities.CurrentFragment;
import com.example.sefinsa_app.utilities.ErrorChecker;
import com.example.sefinsa_app.utilities.PrestamosAdapter;
import com.example.sefinsa_app.utilities.ProgressDialogFragment;
import com.example.sefinsa_app.utilities.RealPathUtil;
import com.example.sefinsa_app.utilities.Utils;
import com.example.sefinsa_app.utilities.VolleyS;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.textfield.TextInputEditText;
import com.google.gson.Gson;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.layout.element.Paragraph;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.layout.Document;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.layout.element.Image;
public class PrestamosFragment extends Fragment implements NetworkChangeReceiver.NetworkChangeListener {
    private final int CODIGO_PERMISOS_CAMARA = 1;
    private boolean camaraGarantiasRetiradas = false;
    public Uri image_uri,selectedImageUri;
    private static final List<Prestamo> prestamosTotales = new ArrayList<>();
    private PrestamosViewModel mViewModel;
    public static ArrayList<Prestamo> prestamos, prestamosFiltrados, prestamosFiltradosNombres;
    public static ArrayList<Pago> pagos;
    private VolleyS vs;
    private RequestQueue requestQueue;

    private static TextInputEditText svPrestamos;
    private static ShimmerFrameLayout shimmer;
    private static RecyclerView recyclerView;
    public static PrestamosAdapter prestamosAdapter;
    private LinearLayoutManager linearLayoutManager;
    private View dialogView2;
    private SharedPreferences sesion;

    private AutoCompleteTextView modalidadesAutoCompleteTextView, rutasAutoCompleteTextView,
            poblacionesAutoCompleteTextView;

    private TextView gruposAutoCompleteTextView;

    private ArrayList<Ruta> rutas;
    private ArrayAdapter<Ruta> rutasAdapter;

    private ArrayList<ConfiguracionSemana> configuracionSemanas;
    private ArrayList<Poblacion> poblaciones;
    private ArrayAdapter<Poblacion> poblacionesAdapter;
    private Button btnCamGarantiasRetiradas, btnGuardarGarantiasRetiradas;
    private ArrayList<Grupo> grupos;
    private ArrayAdapter<Grupo> gruposAdapter;
    private ArrayList<Modalidad> modalidades;
    private ArrayAdapter<Modalidad> modalidadesAdapter;

    private static String modalidad_id = "1";
    private static String ruta_id = "";
    private static String poblacion_id = "";
    private String grupo = "";

    private int previousLength;
    private boolean backSpace;

    private ConfiguracionSemanasController configuracionSemanaController;
    private RutaController rutaController;
    private PoblacionController poblacionController;
    private PagoController pagoController;

    private Button btnPagar, btnPagarConMulta, btnNoPagar, btnAplicar, btnCancelar, btnCambiarAval, btnAdelantar;
    private TextView tvSeleccion, textViewMensajes;

    private LinearLayoutCompat botones;
    String path;
    private int banderaGarantiasRetiradas = 0;
    private ArrayList<PagosHechos> pagosHechos;
    private Fragment fragmento;
    private ArrayList<MultipartBody.Part> archivosGeneral = new ArrayList<>();
    private ArrayList<String> pathsGarantiasRetiradas = new ArrayList<>();
    private final int CODIGO_PERMISOS_BLUETOOTH = 666;
    File pdfFile;
    private NetworkSpeedChecker speedChecker;
    private static ProgressDialog dialog;
    public static boolean shouldStartPolling = true;
    private static final boolean shouldStopLoading = false;
    private static boolean isShimmerActive = false;
    private int retryCount = 0;
    private int retryCountPagos = 0;// Contador de reintentos
    private static final int MAX_RETRIES = 80; // Máximo de reintentos
    private boolean isConnected = true;
    private static final boolean isPrestamosWorkerRunning = false;
    private ProgressDialogFragment progressDialogFragment;
    public PrestamosFragment() {
    }


    public static PrestamosFragment newInstance() {
        return new PrestamosFragment();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
                             @Nullable Bundle savedInstanceState) {
        setHasOptionsMenu(true);
        getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        //Toast.makeText(getActivity(), "r " +ruta_id, Toast.LENGTH_SHORT).show();
        View view = inflater.inflate(R.layout.fragment_prestamos, container, false);
        isSessionActive = true;
        if (archivosGeneral == null) {
            archivosGeneral = new ArrayList<>();
        }
        if (pathsGarantiasRetiradas == null) {
            pathsGarantiasRetiradas = new ArrayList<>();
        }
        if (speedChecker != null) {
            speedChecker.startChecking();
        }
        return view;
    }


    @Override
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        isSessionActive = true;
        modalidadesAutoCompleteTextView.setText(modalidadesAutoCompleteTextView.getAdapter().getItem(0).toString(), false);
        if (rutasAutoCompleteTextView != null)
            rutasAutoCompleteTextView.setText("");
        if (poblacionesAutoCompleteTextView != null)
            poblacionesAutoCompleteTextView.setText("");
        if (gruposAutoCompleteTextView != null)
            gruposAutoCompleteTextView.setText("");
        if (svPrestamos != null)
            svPrestamos.setText("");
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        super.onCreateOptionsMenu(menu, inflater);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        switch (item.getItemId()) {
            case R.id.action_refresh:
                refreshData("");
                return true;
            default:
                return super.onOptionsItemSelected(item);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case CODIGO_PERMISOS_BLUETOOTH:
                if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    BluetoothPrint printBT = new BluetoothPrint(getActivity(), getActivity().getResources());

                    BluetoothPrint.printer_id = "SP-T12 Printer";
                    Log.d("DEBUG", "URI de printBT: " + printBT);
                    try {
                        printBT.findBT();
                        printBT.openBT();
                    }catch (IOException ex){ex.printStackTrace();}

                } else {
                    Toast.makeText(getActivity(), "Es necesario dar los permisos de bluetooth", Toast.LENGTH_SHORT).show();
                }
                break;
        }
    }
    private Bitmap resizeBitmap(Bitmap bitmap, int maxSize) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float bitmapRatio = (float) width / (float) height;

        if (bitmapRatio > 1) {
            width = maxSize;
            height = (int) (width / bitmapRatio);
        } else {
            height = maxSize;
            width = (int) (height * bitmapRatio);
        }

        Bitmap resizedBitmap = Bitmap.createScaledBitmap(bitmap, width, height, true);
        addDateTimeToBitmap(resizedBitmap);
        return resizedBitmap;
    }
    private File saveBitmapToFile(Bitmap bitmap) throws IOException {
        File file = File.createTempFile("compressed_image", ".jpeg");
        FileOutputStream fos = new FileOutputStream(file);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 90, fos);
        fos.flush();
        fos.close();
        return file;
    }
    private String getCurrentDateTime() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE dd MMMM yyyy - HH:mm:ss", new Locale("es", "MX"));
        String dateTime = sdf.format(now);
        return dateTime.toUpperCase();
    }
    private void addDateTimeToBitmap(Bitmap bitmap) {
        String currentDateTime = getCurrentDateTime();

        Canvas canvas = new Canvas(bitmap);

        Paint backgroundPaint = new Paint();
        backgroundPaint.setColor(Color.parseColor("#80000000"));
        canvas.drawRect(0, bitmap.getHeight() - 40, bitmap.getWidth(), bitmap.getHeight(), backgroundPaint);

        Paint textPaint = new Paint();
        textPaint.setColor(Color.WHITE); // Color del texto
        textPaint.setTextSize(18); // Tamaño del texto
        textPaint.setAntiAlias(true); // Suavizar el texto

        float x = 10;
        float y = bitmap.getHeight() - 15;

        canvas.drawText(currentDateTime, x, y, textPaint);
    }
    public void openCameraIntent() {
        //Log.d("DEBUG", "Iniciando openCameraIntent()");
        ContentValues values = new ContentValues();
        values.put(MediaStore.Images.Media.TITLE, "Imagen ejemplo");
        values.put(MediaStore.Images.Media.DESCRIPTION, "Camara ejemplo");
        camaraGarantiasRetiradas = true;
        image_uri = null;
        image_uri = getContext().getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        //Log.d("DEBUG", "URI de imagen válida2: " + image_uri.toString());
        Intent i = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);
        i.putExtra(MediaStore.EXTRA_OUTPUT, image_uri);
        startActivityForResult(i, CODIGO_PERMISOS_CAMARA);
    }
    public void openGalleryIntent() {
        camaraGarantiasRetiradas = true;
        Intent pickPhotoIntent = new Intent(Intent.ACTION_GET_CONTENT);
        pickPhotoIntent.setType("image/*");
        pickPhotoIntent.putExtra(Intent.EXTRA_ALLOW_MULTIPLE, true);
        startActivityForResult(Intent.createChooser(pickPhotoIntent, "Selecciona imágenes"), CODIGO_PERMISOS_CAMARA);
    }
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == CODIGO_PERMISOS_CAMARA) {
            if (resultCode == Activity.RESULT_OK) {
                if (camaraGarantiasRetiradas) {
                    if (data != null) {
                        ClipData clipData = data.getClipData();
                        if (clipData != null) {
                            for (int i = 0; i < clipData.getItemCount(); i++) {
                                Uri uri = clipData.getItemAt(i).getUri();
                                if (uri != null) {
                                    String path = RealPathUtil.getRealPath(getActivity(), uri);
                                    if (path != null && !pathsGarantiasRetiradas.contains(path)) {
                                        pathsGarantiasRetiradas.add(path);
                                        Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                                        Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                                        try {
                                            File file = Utils.getBitmapFile(reduceBitmap, path);
                                            RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                                            MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_retirada_" + i, i + "GA.jpeg", requestFile);
                                            if (!archivosGeneral.contains(body)) {
                                                archivosGeneral.add(body);
                                            }
                                        } catch (Exception e) {
                                            Toast.makeText(getActivity(), e.getMessage(), Toast.LENGTH_LONG).show();
                                        }
                                    }
                                }
                            }
                        } else {
                            Uri uri = data.getData();
                            if (uri != null) {
                                String path = RealPathUtil.getRealPath(getActivity(), uri);
                                if (path != null && !pathsGarantiasRetiradas.contains(path)) {
                                    pathsGarantiasRetiradas.add(path);
                                    Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                                    Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                                    try {
                                        File file = Utils.getBitmapFile(reduceBitmap, path);
                                        RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                                        MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_retirada_0", "0GA.jpeg", requestFile);
                                        if (!archivosGeneral.contains(body)) {
                                            archivosGeneral.add(body);
                                        }
                                    } catch (Exception e) {
                                        Toast.makeText(getActivity(), e.getMessage(), Toast.LENGTH_LONG).show();
                                    }
                                }
                            }
                        }
                    } else {
                        String path = RealPathUtil.getRealPath(getActivity(), image_uri);
                        if (path != null && !pathsGarantiasRetiradas.contains(path)) {
                            pathsGarantiasRetiradas.add(path);
                            Bitmap fullBitmap = BitmapFactory.decodeFile(path);
                            Bitmap reduceBitmap = Utils.reduceBitmapSize(fullBitmap, 950000);
                            try {
                                File file = Utils.getBitmapFile(reduceBitmap, path);
                                RequestBody requestFile = RequestBody.create(MediaType.parse("multipart/form-data"), file);
                                MultipartBody.Part body = MultipartBody.Part.createFormData("garantia_retirada_0", "0GA.jpeg", requestFile);
                                if (!archivosGeneral.contains(body)) {
                                    archivosGeneral.add(body);
                                }
                            } catch (Exception e) {
                                Toast.makeText(getActivity(), e.getMessage(), Toast.LENGTH_LONG).show();
                            }
                        }
                    }

                    banderaGarantiasRetiradas = pathsGarantiasRetiradas.size() - 1;

                    HashSet<String> set = new HashSet<>(pathsGarantiasRetiradas);
                    pathsGarantiasRetiradas.clear();
                    pathsGarantiasRetiradas.addAll(set);

                    HashSet<MultipartBody.Part> setArchivos = new HashSet<>(archivosGeneral);
                    archivosGeneral.clear();
                    archivosGeneral.addAll(setArchivos);

                    prestamosAdapter.updateButtonText();
                    if (prestamosAdapter == null) {
                        prestamosAdapter = new PrestamosAdapter(getActivity(), this, prestamos, archivosGeneral, pathsGarantiasRetiradas, null, null);
                        recyclerView.setAdapter(prestamosAdapter);
                    } else {
                        prestamosAdapter.addFilesAndPaths(archivosGeneral, pathsGarantiasRetiradas);
                        prestamosAdapter.notifyDataSetChanged();
                        prestamosAdapter.notifyDataSetChanged();
                    }
                }
                camaraGarantiasRetiradas = false;
            }
        }
    }
    public void compartirTexto(String titulo_ticket, String ruta_ticket, String Poblacion_ticket, String Nombre_ticket, String Atraso_ticket, String pago_ticket, String aviso, String aviso2, String empleado_ticket, String colocadora_ticket, String aval_ticket, String recargos_ticket, String monto_tot_ticket)
    {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());

            String text = "\n";
            text += titulo_ticket+"\n";
            text += fechaConvert+"\n";

            text += ruta_ticket+"\n";
            text += Poblacion_ticket +"\n";
            text += colocadora_ticket +"\n";
            text += Nombre_ticket +"\n";
            text += aval_ticket +"\n";
            text += pago_ticket+ "\n";
            text += Atraso_ticket + "\n";
            text += recargos_ticket+ "\n";
            text += monto_tot_ticket+ "\n";
            text += aviso+"\n";
            text += empleado_ticket+"\n";
            text += aviso2+"\n";

            // Generar el archivo PDF
            pdfFile = generarPDF(text,"");

            // Compartir el archivo PDF
            compartirPDF(pdfFile);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    public void compartirTextoPago(Prestamo pago, String folio, String recibido, String pago_multa, String concepto, String fecha, String recibido_con_letra, String tipo_ticket)
    {
        try {
            String fechaConvert = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS", Locale.getDefault()).format(new Date());

            String text = "--------------------------\n";
            text += "Folio: "+ folio+"\n";
            text += fechaConvert+"\n";
            text += "Ruta: "+pago.getNombre_ruta()+"\n";
            text += "Poblacion: "+pago.getNombre_poblacion()+"\n";
            text += "Recibi de: "+pago.getNombre_completo()+"\n";
            text += "Cantidad: $"+recibido + "\n";
            text += "("+recibido_con_letra + "PESOS 00/100 MN)"+ "\n";
            //text += "Debe: $"+ (Double.parseDouble(pago.getBalance()) - Double.parseDouble(recibido)) + "\n";
            if(pago_multa != "0.0") text += "Multa: $"+ pago_multa + "\n";
            text += "Concepto: "+concepto+"\n";
            text += "--------------------------\n";

            // Generar el archivo PDF
            pdfFile = generarPDF(text,tipo_ticket);

            // Compartir el archivo PDF
            compartirPDF(pdfFile);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    private File generarPDF(String content, String tipo_ticket) throws IOException {
        // Crear un nuevo documento PDF
        if(tipo_ticket.equals("Pago"))
        {
            pdfFile = new File(getContext().getCacheDir(), "Recibo de pago.pdf");
        }
        else
        {
            pdfFile = new File(getContext().getCacheDir(), "Requerimiento de pago.pdf");
        }

        PdfWriter writer = new PdfWriter(pdfFile);
        PdfDocument pdf = new PdfDocument(writer);
        Document document = new Document(pdf);

        // Obtener la imagen desde los recursos y agregarla al PDF
        Drawable drawable = getResources().getDrawable(R.drawable.sefinsa_ticket);
        BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
        Bitmap bitmap = bitmapDrawable.getBitmap();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
        ImageData imageData = ImageDataFactory.create(stream.toByteArray());
        Image image = new Image(imageData);
        document.add(image);

        // Agregar el contenido al PDF
        document.add(new Paragraph(content));

        // Cerrar el documento
        document.close();

        return pdfFile;
    }

    private void compartirPDF(File pdfFile) {
        try {
            Intent intent = new Intent(Intent.ACTION_SEND);
            intent.setType("application/pdf");
            Uri pdfUri = FileProvider.getUriForFile(getContext(), getContext().getApplicationContext().getPackageName() + ".provider", pdfFile);
            intent.putExtra(Intent.EXTRA_STREAM, pdfUri);
            startActivity(Intent.createChooser(intent, "Compartir mediante"));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    public static void startShimmer() {
        if (shimmer != null) { // Verificar que la referencia no sea nula
            startShimmer();
            shimmer.setVisibility(View.VISIBLE); // Asegurarte de que sea visible
            isShimmerActive = true; // Marcar que el shimmer está activo
        }
    }

    public static void stopShimmer() {
        if (shimmer != null) { // Verificar que la referencia no sea nula
            shimmer.stopShimmer();
            shimmer.setVisibility(View.GONE); // Asegurarte de que sea visible
            isShimmerActive = false; // Marcar que el shimmer está activo
        }
    }
    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        CurrentFragment.fragment = "PrestamosFragment";
        //Log.d("CurrentFragment", "El fragmento actual es: " + CurrentFragment.fragment);
        ruta_id="";
        poblacion_id="";
        modalidad_id="1";
        retryCount = 0;
        retryCountPagos = 0;// Contador de reintentos
        sesion = getActivity().getSharedPreferences("sesion", Context.MODE_PRIVATE);
        prestamos = new ArrayList<>();
        pagos = new ArrayList<>();
        prestamosFiltrados = new ArrayList<>();
        pagoController = new PagoController(getActivity());
        View dialogView4 = LayoutInflater.from(getContext()).inflate(R.layout.dialog_tipo_pago, null);

        // Obtener referencia al botón en el diseño del diálogo
        btnCamGarantiasRetiradas = dialogView4.findViewById(R.id.btnCamGarantiasRetiradas);
        // Verificar si el botón se ha inicializado correctamente
        if (btnCamGarantiasRetiradas != null) {
            Log.d("DEBUG", "El botón es nulo");
        } else {
            Log.d("DEBUG", "El botón es nulo");
        }

        Bundle bundle = this.getArguments();

        pagosHechos = new ArrayList<>();

        configuracionSemanaController = new ConfiguracionSemanasController(getActivity());
        rutaController = new RutaController(getActivity());
        poblacionController = new PoblacionController(getActivity());
        pagoController = new PagoController(getActivity());


        shimmer = view.findViewById(R.id.sfClientes);

        recyclerView = view.findViewById(R.id.rvPrestamos);
        svPrestamos = view.findViewById(R.id.svPrestamos);

        shimmer.startShimmer();


        tvSeleccion = getView().findViewById(R.id.tvSeleccion);
        rutasAutoCompleteTextView = view.findViewById(R.id.acRuta);
        poblacionesAutoCompleteTextView = view.findViewById(R.id.acPoblacion);
        gruposAutoCompleteTextView = view.findViewById(R.id.tvGrupo);
        modalidadesAutoCompleteTextView = view.findViewById(R.id.acModalidad);
        textViewMensajes = getActivity().findViewById(R.id.message_text);
        btnPagar = view.findViewById(R.id.btnPagar);
        btnNoPagar = view.findViewById(R.id.btnNoPagar);
        btnAdelantar = view.findViewById(R.id.btnAdelantarPagoPrestamo);

        btnPagarConMulta = view.findViewById(R.id.btnPagarConMulta);

        btnAplicar = view.findViewById(R.id.btnAplicar);
        btnAplicar.setOnClickListener(view1 -> {
            // Obtén una instancia del layout inflado
            LayoutInflater inflater = LayoutInflater.from(getActivity());
            View dialogView = inflater.inflate(R.layout.dialog_tipo_pago, null);

            // Configura el Spinner y carga las opciones
            Spinner spinnerOptions = dialogView.findViewById(R.id.spinnerOptions);
            String[] opciones = {"", "Efectivo", "Transferencia","Garantía"};

            // Configura un ArrayAdapter para el Spinner
            ArrayAdapter<String> adapter = new ArrayAdapter<>(getActivity(), android.R.layout.simple_spinner_item, opciones);
            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
            spinnerOptions.setAdapter(adapter);
            TextView textPlaceholder2 = dialogView.findViewById(R.id.textPlaceholder);
            textPlaceholder2.setOnClickListener(v -> {
                textPlaceholder2.setVisibility(View.GONE);
                spinnerOptions.performClick();
            });

            AlertDialog dialog = new AlertDialog.Builder(getActivity())
                    .setView(dialogView)
                    .setTitle("Aplicar acciones")
                    .setPositiveButton("Sí", (dialogInterface, i) -> {

                        if (prestamosAdapter.prestamosPagar.size() == 0 &&
                                prestamosAdapter.prestamosPagarConMulta.size() == 0 &&
                                prestamosAdapter.prestamosNoPagar.size() == 0 &&
                                prestamosAdapter.prestamosAdelantar.size() == 0) {
                            Toast.makeText(getActivity(), "Debes seleccionar al menos una semana", Toast.LENGTH_SHORT).show();
                        } else {

                            // Manejo de préstamos a pagar
                            if (prestamosAdapter.prestamosPagar.size() != 0) {
                                String tipo_pago = (String) spinnerOptions.getSelectedItem();

                                // Crear lista de IDs de los préstamos seleccionados
                                List<Integer> idsPrestamos = new ArrayList<>();
                                for (Prestamo prestamo : prestamosAdapter.prestamosPagar) {
                                    idsPrestamos.add(Integer.valueOf(prestamo.getId()));
                                }

                                // Consultar los préstamos que tienen pagos adelantados
                                Map<Integer, String> prestamosConPagosAdelantados = (Map<Integer, String>) obtenerPrestamosConPagosAdelantados(idsPrestamos);

                                // Filtrar los préstamos válidos (sin semanas adelantadas)
                                List<Prestamo> prestamosValidos = new ArrayList<>();
                                for (Prestamo prestamo : prestamosAdapter.prestamosPagar) {
                                    if (!prestamosConPagosAdelantados.containsKey(Integer.valueOf(prestamo.getId()))) {
                                        prestamosValidos.add(prestamo);
                                    } else {
                                        // Desmarcar préstamos con pagos adelantados
                                        prestamo.setSelectedPagar(false);
                                    }
                                }

                                if (!prestamosConPagosAdelantados.isEmpty()) {
                                    // Construir el mensaje con los números de tarjetón problemáticos
                                    StringBuilder mensaje = new StringBuilder("Los siguientes préstamos tienen pagos adelantados y no serán procesados:\n");
                                    for (Map.Entry<Integer, String> entry : prestamosConPagosAdelantados.entrySet()) {
                                        mensaje.append("Número de Tarjetón: ").append(entry.getValue()).append("\n");
                                    }

                                    // Crear el AlertDialog
                                    new AlertDialog.Builder(requireContext())
                                            .setTitle("Advertencia")
                                            .setMessage(mensaje.toString())
                                            .setPositiveButton("Aceptar", (dialogSA, which) -> {
                                                // Acción cuando se presiona el botón "Aceptar" (opcional)
                                                dialogSA.dismiss();
                                            })
                                            .setCancelable(false) // Evita que se pueda cerrar tocando fuera del diálogo
                                            .show();
                                }


                                if (prestamosValidos.isEmpty()) {
                                    // Si no hay préstamos válidos, cancelar toda la acción
                                    btnPagar.setText("");
                                    prestamosAdapter.prestamosPagar.clear();
                                    return; // Cancelar la acción
                                }

                                // Procesar solo los préstamos válidos
                                for (Prestamo prestamo : prestamosValidos) {
                                    prestamo.setSelectedPagar(false);
                                    pagar(prestamo, tipo_pago);
                                }

                                btnPagar.setText("");
                                prestamosAdapter.prestamosPagar.clear();
                                // refreshData(); // Si necesitas actualizar la UI
                            }

                            if (prestamosAdapter.prestamosAdelantar.size() != 0) {
                                String tipo_pago = (String) spinnerOptions.getSelectedItem();
                                for (Prestamo prestamo : prestamosAdapter.prestamosAdelantar) {
                                    prestamo.setSelectedAdelantar(false);
                                    pagoAdelantar(prestamo, tipo_pago);
                                }
                                btnAdelantar.setText("");
                                prestamosAdapter.prestamosAdelantar.clear();
                                //refreshData();
                            }

                            if (prestamosAdapter.prestamosPagarConMulta.size() != 0) {
                                String tipo_pago = (String) spinnerOptions.getSelectedItem();
                                for (Prestamo prestamo : prestamosAdapter.prestamosPagarConMulta) {
                                    prestamo.setSelectedPagarConMulta(false);
                                    pagarConMulta(prestamo, tipo_pago);
                                }
                                btnPagarConMulta.setText("M");
                                prestamosAdapter.prestamosPagarConMulta.clear();
                                //refreshData();
                            }

                            if (prestamosAdapter.prestamosNoPagar.size() != 0) {

                                for (Prestamo prestamo : prestamosAdapter.prestamosNoPagar) {
                                    prestamo.setSelectedNoPagar(false);
                                    noPagar(prestamo);
                                }
                                btnNoPagar.setText("");
                                prestamosAdapter.prestamosNoPagar.clear();
                                //refreshData();
                            }

                            //Toast.makeText(getActivity(), "Se aplicarón las acciones", Toast.LENGTH_SHORT).show();

                            if (!modalidad_id.equals("") && !ruta_id.equals("") && !poblacion_id.equals("") && !grupo.equals("")) {
                                filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                            } else if (!modalidad_id.equals("") && !ruta_id.equals("") && !poblacion_id.equals("")) {
                                filtrarPrestamos(modalidad_id, ruta_id,"");
                            } else if (!modalidad_id.equals("") && !ruta_id.equals("")) {
                                filtrarPrestamos(modalidad_id,"");
                            } else if (!modalidad_id.equals("")) {
                                filtrarPrestamos(modalidad_id);
                            }

                            btnCancelar.setText("Cancelar (" + (prestamosAdapter.prestamosPagar.size() + prestamosAdapter.prestamosPagarConMulta.size() + prestamosAdapter.prestamosNoPagar.size()) + ")");
                            prestamosAdapter.seleccionAdelantar = false;
                            prestamosAdapter.seleccionPagar = false;
                            prestamosAdapter.seleccionPagarConMulta = false;
                            prestamosAdapter.seleccionNoPagar = false;
                            tvSeleccion.setText("");
                            //filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                        }

                    }).setNegativeButton("No", (dialogInterface, i) -> {
                        // Lógica cuando se hace clic en No
                    })
                    .create();

            // Muestra el cuadro de diálogo
            dialog.show();
        });


        btnCancelar = view.findViewById(R.id.btnCancelar);
        btnCancelar.setOnClickListener(view12 -> new MaterialAlertDialogBuilder(getActivity())
                .setCancelable(false)
                .setTitle("Cancelar selección")
                .setMessage("¿Estas seguro de cancelar la selección?")
                .setPositiveButton("Sí", (dialogInterface, i) -> {

                    if (prestamosAdapter.prestamosPagar.size() != 0) {
                        for (Prestamo prestamo : prestamosAdapter.prestamosPagar) {
                            prestamo.setSelectedPagar(false);
                        }
                        //filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                        btnPagar.setText("");
                        prestamosAdapter.prestamosPagar.clear();
                    }

                    if (prestamosAdapter.prestamosAdelantar.size() != 0) {
                        for (Prestamo prestamo : prestamosAdapter.prestamosAdelantar) {
                            prestamo.setSelectedAdelantar(false);
                        }
                        btnAdelantar.setText("");
                        prestamosAdapter.prestamosAdelantar.clear();
                        //filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                    }

                    if (prestamosAdapter.prestamosPagarConMulta.size() != 0) {
                        for (Prestamo prestamo : prestamosAdapter.prestamosPagarConMulta) {
                            prestamo.setSelectedPagarConMulta(false);
                        }
                        btnPagarConMulta.setText("M");
                        prestamosAdapter.prestamosPagarConMulta.clear();
                        //filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                    }

                    if (prestamosAdapter.prestamosNoPagar.size() != 0) {
                        for (Prestamo prestamo : prestamosAdapter.prestamosNoPagar) {
                            prestamo.setSelectedNoPagar(false);
                        }
                        btnNoPagar.setText("");
                        prestamosAdapter.prestamosNoPagar.clear();
                        //filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                    }

                    if (!modalidad_id.equals("") && !ruta_id.equals("") && !poblacion_id.equals("") && !grupo.equals("")) {
                        filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                    } else if (!modalidad_id.equals("") && !ruta_id.equals("") && !poblacion_id.equals("")) {
                        filtrarPrestamos(modalidad_id, ruta_id, "");
                    } else if (!modalidad_id.equals("") && !ruta_id.equals("")) {
                        filtrarPrestamos(modalidad_id,"");
                    } else if (!modalidad_id.equals("")) {
                        filtrarPrestamos(modalidad_id);
                    }
                    btnPagar.setText("");
                    btnPagarConMulta.setText("M");
                    btnNoPagar.setText("");
                    prestamosAdapter.notifyDataSetChanged();

                    btnCancelar.setText("Cancelar (" + (prestamosAdapter.prestamosPagar.size() + prestamosAdapter.prestamosPagarConMulta.size() + prestamosAdapter.prestamosNoPagar.size()) + ")");
                    prestamosAdapter.seleccionPagar = false;
                    prestamosAdapter.seleccionPagarConMulta = false;
                    prestamosAdapter.seleccionNoPagar = false;

                    tvSeleccion.setText("");
                    filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, "");
                })
                .setNegativeButton("No", (dialogInterface, i) -> {

                })
                .show());

        DisplayMetrics displayMetrics = getResources().getDisplayMetrics();
        int screenHeight = displayMetrics.heightPixels;
        double porcentajeGestor = 0.7;  // por ejemplo, el 30% de la pantalla
        double porcentajeAdministrador = 0.55;  // por ejemplo, el 50% de la pantalla

        if (sesion.getString("nombre_perfil", "").equals("COBRADOR") ||
                sesion.getString("nombre_perfil", "").equals("GESTOR")) {
            //int altura = 1600;

            btnNoPagar.setVisibility(View.GONE);
            btnPagarConMulta.setVisibility(View.GONE);
            btnPagar.setVisibility(View.GONE);
            btnCancelar.setVisibility(View.GONE);
            btnAplicar.setVisibility(View.GONE);
            btnAdelantar.setVisibility(View.GONE);
            recyclerView.getLayoutParams().height = (int) (screenHeight * porcentajeGestor);
        }
        else
        {
            //int altura = 1200;
            recyclerView.getLayoutParams().height = (int) (screenHeight * porcentajeAdministrador);
        }

        svPrestamos.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {
                if(modalidad_id!="" && ruta_id!="" && poblacion_id!="")
                {
                    filtrarPrestamos(modalidad_id, ruta_id, poblacion_id,editable.toString());
                }
                else
                {
                    filtrarPrestamosBusqueda(editable.toString());
                }

            }
        });

        linearLayoutManager = new LinearLayoutManager(getContext());
        recyclerView.setLayoutManager(linearLayoutManager);
        prestamosAdapter = new PrestamosAdapter(getActivity(), this, prestamos, archivosGeneral, pathsGarantiasRetiradas, null, null);
        recyclerView.setAdapter(prestamosAdapter);
        recyclerView.getRecycledViewPool().setMaxRecycledViews(0, 0);

        /**
         *  MODALIDADES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        modalidades = new ArrayList<Modalidad>();
        getModalidades();

        modalidadesAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Modalidad modalidad = modalidadesAdapter.getItem(i);

                modalidad_id = modalidad.getId();

                ruta_id = "";
                rutasAutoCompleteTextView.setText("");

                poblacion_id = "";
                poblacionesAutoCompleteTextView.setText("");

                grupo = "";
                gruposAutoCompleteTextView.setText("");

                svPrestamos.setText("");

                filtrarPrestamos(modalidad_id);
                //Log.d("DEBUG", "Antes de clear: " + modalidad_id);
            }

        });

        modalidadesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !modalidad_id.equals("")) {

                    modalidad_id = "";
                    modalidadesAutoCompleteTextView.setText("");

                    ruta_id = "";
                    rutasAutoCompleteTextView.setText("");

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    grupo = "";
                    gruposAutoCompleteTextView.setText("");

                    filtrarPrestamos("1");
                    //filtrarPrestamos(modalidad_id);

                }

            }
        });


        /**
         *  RUTAS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        rutas = new ArrayList<Ruta>();
        poblaciones = new ArrayList<Poblacion>();
        grupos = new ArrayList<Grupo>();
        configuracionSemanas = new ArrayList<ConfiguracionSemana>();

        getConfiguracionSemana();

        getRutas();

        rutasAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {

            @RequiresApi(api = Build.VERSION_CODES.N)
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                Ruta ruta = rutasAdapter.getItem(i);
                ruta_id = ruta.getId();

                if (poblacionesAutoCompleteTextView.getText().toString().length() > 0) {
                    poblacionesAutoCompleteTextView.setText("");
                }
                if (gruposAutoCompleteTextView.getText().toString().length() > 0) {
                    gruposAutoCompleteTextView.setText("");
                }

                filtrarPrestamos(modalidad_id, ruta_id, "");
                //Log.d("DEBUG", "Antes de clear: " + modalidad_id +" / "+ ruta_id);
                List<Poblacion> poblacionesFiltro =
                        poblaciones.stream().filter(poblacion -> poblacion.getRuta_id().equals(ruta_id)).collect(Collectors.toList());

                poblacionesAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, poblacionesFiltro);
                poblacionesAutoCompleteTextView.setThreshold(1);
                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

            }
        });

        rutasAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !ruta_id.equals("")) {

                    ruta_id = "";
                    rutasAutoCompleteTextView.setText("");

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    grupo = "";
                    gruposAutoCompleteTextView.setText("");

                    svPrestamos.setText("");

                    filtrarPrestamos(modalidad_id);

                }

            }
        });

        /**
         *  POBLACIONES ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        if (poblaciones.size() == 0) {
            getPoblaciones(ruta_id);
        }

        poblacionesAutoCompleteTextView.setOnItemClickListener((adapterView, view13, i, l) -> {
            Poblacion poblacion = poblacionesAdapter.getItem(i);
            poblacion_id = poblacion.getId();

            filtrarPrestamos(modalidad_id, ruta_id, poblacion_id,"");
            //Log.d("DEBUG", "Antes de clear Poblacion: " + modalidad_id +" / "+ ruta_id+" / "+ poblacion_id);
        });

        poblacionesAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace && !poblacion_id.equals("")) {

                    poblacion_id = "";
                    poblacionesAutoCompleteTextView.setText("");

                    grupo = "";
                    gruposAutoCompleteTextView.setText("");

                    svPrestamos.setText("");

                    filtrarPrestamos(modalidad_id);

                }

            }
        });


        /**
         *  GRUPOS ADAPTER PARA AUTOCOMPLETTEXTVIEW
         */
        //getGrupos();

        /*gruposAutoCompleteTextView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {

                Grupo grupoObj = gruposAdapter.getItem(i);
                grupo = grupoObj.getGrupo_poblacion();

                filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, grupo);

            }
        });*/

        gruposAutoCompleteTextView.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                previousLength = s.length();
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            @Override
            public void afterTextChanged(Editable s) {
                backSpace = previousLength > s.length();

                if (backSpace) {

                    grupo = "";
                    gruposAutoCompleteTextView.setText("");

                    filtrarPrestamos(modalidad_id, ruta_id, poblacion_id);

                } else {
                    if (s.length() > 0) {
                        grupo = s.toString();
                        filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, s.toString());
                    }
                }

            }
        });

        svPrestamos.setText("");

        if (getParentFragmentManager().findFragmentByTag("progressDialog") == null) {
            progressDialogFragment = new ProgressDialogFragment();
            progressDialogFragment.show(getParentFragmentManager(), "progressDialog");
        }
        if (!isNetworkAvailable()) {

            PrestamosWorker.isTaskPrestamosCompleted = true;
            PagosWorker.isTaskPagosCompleted = true;

            cargarPrestamosConsulta();

            //recyclerView.setVisibility(View.VISIBLE);
            // Ocultar el ProgressDialog si está mostrando
            //progressDialogFragment.dismissAllowingStateLoss();
        }
        else {
            isTableEmpty("clientes", new PrestamosFragment.IsTableEmptyCallback() {
                @Override
                public void onResult(boolean isClientesEmpty) {
                    if (isClientesEmpty) {
                        //Log.d("PRESTAMOS", "CLIENTES ESTÁ VACÍA. Ejecutando ClientesWorker FULL...");
                        ClientesWorker.allDataLoadedClientes = false;
                        ClientesWorker.currentPageClientes = 0;
                        ClientesWorker.isTaskClientesCompleted = false;
                        ClientesWorker.enqueueWork(requireContext());
                    } else {
                        //Log.d("PRESTAMOS", "CLIENTES NO ESTÁ VACÍA. Ejecutando ClientesWorker UPDATE...");
                        ClientesWorker.allDataLoadedClientes = true;
                        ClientesWorker.currentPageClientes = 0;
                        ClientesWorker.isTaskClientesCompleted = false;
                        ClientesWorker.enqueueWork(requireContext());
                    }
                    checckBanderaClientes();
                }
            });
        }
    }

    public Map<Integer, String> obtenerPrestamosConPagosAdelantados(List<Integer> prestamoIds) {
        String ids = TextUtils.join(",", prestamoIds);
        // Consulta con INNER JOIN para obtener numero_tarjeton junto con el prestamo_id
        String query = "SELECT DISTINCT p.prestamo_id, pr.numero_tarjeton " +
                "FROM pagos p " +
                "INNER JOIN prestamos pr ON p.prestamo_id = pr.id " +
                "WHERE p.prestamo_id IN (" + ids + ") AND p.status = 4";

        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Cursor cursor = db.rawQuery(query, null);

        // Usar un Map para almacenar prestamo_id y su numero_tarjeton correspondiente
        Map<Integer, String> resultados = new HashMap<>();
        while (cursor.moveToNext()) {
            int prestamoId = cursor.getInt(0);
            String numeroTarjeton = cursor.getString(1);
            resultados.put(prestamoId, numeroTarjeton);
        }
        cursor.close();
        db.close();
        return resultados;
    }


    @Override
    public void onResume() {
        super.onResume();
        CurrentFragment.fragment = "PrestamosFragment";
        Log.d("CurrentFragment", "El fragmento actual es: " + CurrentFragment.fragment);
    }
    private void checckBanderaClientes() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (ClientesWorker.isTaskClientesCompleted) {
                isTableEmpty("avales", new PrestamosFragment.IsTableEmptyCallback() {
                    @Override
                    public void onResult(boolean isAvalesEmpty) {
                        if (isAvalesEmpty) {
                            Log.d("PRESTAMOS", "AVALES ESTÁ VACÍA. Ejecutando AvalesWorker FULL...");
                            AvalesWorker.allDataLoadedAvales = false;
                            AvalesWorker.currentPageAvales = 0;
                            AvalesWorker.isTaskAvalesCompleted = false;
                            AvalesWorker.enqueueWork(requireContext());
                        } else {
                            Log.d("PRESTAMOS", "AVALES NO ESTÁ VACÍA. Ejecutando AvalesWorker UPDATE EN PRESTAMOS...");
                            AvalesWorker.allDataLoadedAvales = true;
                            AvalesWorker.currentPageAvales = 0;
                            AvalesWorker.isTaskAvalesCompleted = false;
                            AvalesWorker.enqueueWork(requireContext());
                        }
                        checckBanderaAvales();
                    }
                });
            } else {
                Log.d("PRESTAMOS", "Tareas aún no completadas. Reintentando en 500ms... AvalesWorker");
                checckBanderaClientes(); // Reintenta después de 500ms
            }
        }, 1000); // Intervalo de 500ms para verificar
    }

    private void checckBanderaAvales() {
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            if (AvalesWorker.isTaskAvalesCompleted) {
                Log.d("PRESTAMOS", "Ambas tareas completadas. Ejecutando lógica de préstamos...");
                ejecutarLogicaPrestamos();
            } else {
                Log.d("PRESTAMOS", "Tareas aún no completadas. Reintentando en 500ms...");
                checckBanderaAvales(); // Reintenta después de 500ms
            }
        }, 1000); // Intervalo de 500ms para verificar
    }
    // Método separado para manejar la lógica específica de PrestamosWorker
    private void ejecutarLogicaPrestamos() {
        countPrestamosInSQLite(requireContext(), 3, new PrestamosFragment.CountPrestamosCallback() {
            @Override
            public void onResult(boolean result) {
                // Si result es true, significa que hay menos de 2 registros en la tabla
                if (result) {
                    PrestamosWorker.currentPagePrestamos = 0;
                    PrestamosWorker.allDataLoadedPrestamos = false;
                    PrestamosWorker.isTaskPrestamosCompleted = false;
                    PrestamosWorker.enqueueWork(requireContext());

                    new Handler(Looper.getMainLooper()).postDelayed(() -> {
                        checkForUpdatesAndLoadCache();
                    }, 4000);

                    Log.d("PRESTAMOS", "Cargando enqueueWork menos de 2 registros.");
                } else {
                    PrestamosWorker.currentPagePrestamos = 0;
                    PrestamosWorker.allDataLoadedPrestamos = true;
                    PrestamosWorker.isTaskPrestamosCompleted = false;
                    PrestamosWorker.enqueueWork(requireContext());

                    new Handler(Looper.getMainLooper()).postDelayed(() -> {
                        checkForUpdatesAndLoadCache();
                    }, 1000); // 1000 milisegundos

                    Log.d("PRESTAMOS", "Cargando desde caché, más de 2 registros. PrestamosWorker");
                }
            }
        });
    }

    private void isTableEmpty(String tableName, PrestamosFragment.IsTableEmptyCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        executor.execute(() -> {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            boolean isEmpty = true;

            try {
                // Usar la base de datos según la tabla solicitada
                if (tableName.equalsIgnoreCase("clientes")) {
                    db = new DatabaseHelper(requireContext()).getReadableDatabase();
                } else if (tableName.equalsIgnoreCase("avales")) {
                    db = new DatabaseHelper(requireContext()).getReadableDatabase();
                } else {
                    throw new IllegalArgumentException("Tabla desconocida: " + tableName);
                }

                // Consultar la tabla
                cursor = db.rawQuery("SELECT COUNT(*) FROM " + tableName, null);
                if (cursor != null && cursor.moveToFirst()) {
                    isEmpty = cursor.getInt(0) == 0; // Vacía si el conteo es 0
                }
            } finally {
                executor.shutdown();
                if (cursor != null) cursor.close();
                if (db != null) db.close();
            }

            // Llamar al callback en el hilo principal
            boolean finalIsEmpty = isEmpty;
            getActivity().runOnUiThread(() -> {
                callback.onResult(finalIsEmpty);
            });
        });
    }


    public interface IsTableEmptyCallback {
        void onResult(boolean isEmpty);
    }
    private void cargarPagosDesdeSQLite() {
        DatabaseHelper dbHelper = new DatabaseHelper(getContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        // Definir columnas a obtener
        String[] columnas = {
                "id", "prestamo_id", "cantidad_esperada_pago", "cantidad_normal_pagada", "cantidad_multa",
                "cantidad_pendiente", "cantidad_total_pagada", "concepto",
                "fecha_pago", "fecha_pago_realizada", "folio", "semana",
                "balance", "empleado_id", "status", "updated_at", "tipo_pago", "recuperado", "sinc"
        };

        // Ejecutar la consulta
        Cursor cursor = db.query("pagos", columnas, null, null, null, null, "id DESC");

        pagos.clear(); // Limpiar lista en caso de recarga
        if (cursor != null && cursor.moveToFirst()) {
            do {
                Pago pago = new Pago(
                        cursor.getString(cursor.getColumnIndexOrThrow("id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("prestamo_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("cantidad_esperada_pago")),
                        cursor.getString(cursor.getColumnIndexOrThrow("cantidad_normal_pagada")),
                        cursor.getString(cursor.getColumnIndexOrThrow("cantidad_multa")),
                        cursor.getString(cursor.getColumnIndexOrThrow("cantidad_pendiente")),
                        cursor.getString(cursor.getColumnIndexOrThrow("cantidad_total_pagada")),
                        cursor.getString(cursor.getColumnIndexOrThrow("concepto")),
                        cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago")),
                        cursor.getString(cursor.getColumnIndexOrThrow("fecha_pago_realizada")),
                        cursor.getString(cursor.getColumnIndexOrThrow("folio")),
                        cursor.getString(cursor.getColumnIndexOrThrow("semana")),
                        cursor.getString(cursor.getColumnIndexOrThrow("balance")),
                        cursor.getString(cursor.getColumnIndexOrThrow("empleado_id")),
                        cursor.getString(cursor.getColumnIndexOrThrow("status")),
                        cursor.getString(cursor.getColumnIndexOrThrow("updated_at")),
                        cursor.getString(cursor.getColumnIndexOrThrow("tipo_pago")),
                        cursor.getString(cursor.getColumnIndexOrThrow("recuperado")),
                        cursor.getString(cursor.getColumnIndexOrThrow("sinc"))
                );
                pagos.add(pago);
            } while (cursor.moveToNext());
            cursor.close();
        }
        db.close();

        int totalRegistros = pagos.size();
        Log.d("SQLitePrestamos", "Total de Pagos registros en SQLite: " + totalRegistros);

        // Actualizar la UI si hay registros y la tarea se completó
        if (totalRegistros >= 0) {
            cargarPrestamosConsulta();
        } else {
            Log.d("PrestamosFragment", "No hay registros o la tarea no está completa.");
        }
    }

    private void cargarPrestamosDesdeSQLite() {
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();
        Log.d("PagosWorker", "Entro en cargarPrestamosDesdeSQLite()...................");

        // Definir columnas a obtener
        String[] columnas = {
                "id",
                "numero_tarjeton",
                "updated_at"
        };

        Cursor cursor = null;
        if (sesion.getString("nombre_perfil", "").equals("VOCERO") ||
                sesion.getString("nombre_perfil", "").equals("Administrador") ||
                sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {

            cursor = db.query("prestamos", columnas, "status != ?", new String[]{"-1"}, null, null, "id DESC");

        } else {
            cursor = db.query("prestamos", columnas, null, null, null, null, "id DESC");
        }

        // Log para verificar si el cursor es null
        if (cursor == null) {
            Log.e("PagosWorker", "El cursor es null, no se pudo realizar la consulta a la base de datos.");
        }

        prestamos.clear(); // Limpiar lista en caso de recarga
        if (cursor != null && cursor.moveToFirst()) {
            do {
                String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String numeroTarjeton = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                String updatedAt = cursor.getString(cursor.getColumnIndexOrThrow("updated_at"));

                // Log para verificar los resultados obtenidos de la consulta
                Log.d("PagosWorker", "Consulta de préstamo: ID = " + prestamoId + ", Número Tarjetón = " + numeroTarjeton);

                Prestamo prestamo = new Prestamo(prestamoId, numeroTarjeton, updatedAt);
                prestamos.add(prestamo);

            } while (cursor.moveToNext());
            cursor.close();
        } else {
            Log.e("PagosWorker", "No se encontraron registros en la base de datos.");
        }

        int totalRegistros = prestamos.size();

        // Log para verificar cuántos préstamos se han cargado
        Log.d("PagosWorker", "Total de registros de préstamos encontrados: " + totalRegistros);

        // Actualizar la UI si hay registros y la tarea se completó
        if (totalRegistros >= 0 && PrestamosWorker.isTaskPrestamosCompleted) {
            PagosWorker.allPagos = new ArrayList<>();

            prestamos.sort((p1, p2) -> {
                String updatedAt1 = p1.getUpdated_at();
                String updatedAt2 = p2.getUpdated_at();
                String prestamoId1 = p1.getId(); // Obtener el ID del primer préstamo
                String prestamoId2 = p2.getId(); // Obtener el ID del segundo préstamo

                // Verificar si alguno de los valores es null y asignar el valor mínimo o máximo
                if (updatedAt1 == null && updatedAt2 == null) {
                    return 0; // Ambos son null, no hay diferencia
                } else if (updatedAt1 == null) {
                    return 1; // Si el primero es null, ponerlo después (orden descendente)
                } else if (updatedAt2 == null) {
                    return -1; // Si el segundo es null, ponerlo después (orden descendente)
                } else {
                    // Ambos no son null, comparar normalmente
                    return updatedAt2.compareTo(updatedAt1); // Orden descendente
                }
            });


            for (Prestamo prestamo : prestamos) {
                String prestamoId = prestamo.getId();

                // Validar que el ID no sea null o vacío antes de convertirlo a Integer
                if (prestamoId != null && !prestamoId.isEmpty()) {
                    try {
                        PagosWorker.allPagos.add(Integer.valueOf(prestamoId));
                    } catch (NumberFormatException e) {
                        Log.e("PagosWorker", "ID de préstamo no es un número válido: " + prestamoId);
                    }
                } else {
                    Log.w("PagosWorker", "ID de préstamo nulo o vacío omitido.");
                }
            }

            // Mostrar la lista de préstamos que se han agregado a allPagos
            Log.d("PagosWorker", "Lista de préstamos enviados a allPagos: " + PagosWorker.allPagos.toString());

        } else {
            Log.d("PrestamosFragment", "No hay registros o la tarea no está completa.");
        }
    }


    private void verificarPrestamosSinCliente() {
        DatabaseHelper dbHelper = new DatabaseHelper(getContext());
        SQLiteDatabase db = dbHelper.getReadableDatabase();

        String query = "SELECT prestamos.id, prestamos.cliente_id " +
                "FROM prestamos " +
                "LEFT JOIN clientes ON prestamos.cliente_id = clientes.id " +
                "WHERE clientes.id IS NULL";

        Cursor cursor = db.rawQuery(query, null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                String clienteId = cursor.getString(cursor.getColumnIndexOrThrow("cliente_id"));
                //Log.e("PrestamosSinCliente", "Prestamo ID: " + prestamoId + " tiene cliente_id nulo: " + clienteId);
            }
            cursor.close();
        }
        db.close();
    }

    private void cargarPrestamosConsulta() {
        verificarPrestamosSinCliente();
        ExecutorService executor = Executors.newSingleThreadExecutor(); // Executor para tareas en segundo plano

        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(getContext());
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            // Buscar en la base de datos el préstamo con número de tarjetón 117801
            String consultaTarjeton = "SELECT * FROM prestamos WHERE numero_tarjeton = ?";
            Cursor cursorTarjeton = db.rawQuery(consultaTarjeton, new String[]{"117801"});

// Verificar si hay resultados y loguearlos
            if (cursorTarjeton != null && cursorTarjeton.moveToFirst()) {
                do {
                    int idPrestamo = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("id"));
                    int clienteId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("cliente_id"));
                    String direccionCliente = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("direccion_cliente"));
                    String telefonoCliente = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("telefono_cliente"));
                    int rutaId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("ruta_id"));
                    int poblacionId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("poblacion_id"));
                    int colocadoraId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("colocadora_id"));
                    int avalId = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("aval_id"));
                    int grupoPoblacion = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("grupo_poblacion"));
                    int montoPrestado = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("monto_prestado"));
                    int pagoSemanal = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("pago_semanal"));
                    String fechaPrestamo = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("fecha_prestamo"));
                    int modalidadSemanas = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("modalidad_semanas"));
                    int numeroTarjeton = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("numero_tarjeton"));
                    int status = cursorTarjeton.getInt(cursorTarjeton.getColumnIndexOrThrow("status"));
                    String createdAt = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("created_at"));
                    String updatedAt = cursorTarjeton.getString(cursorTarjeton.getColumnIndexOrThrow("updated_at"));

                    // Log de todos los campos del préstamo
                    Log.d("SQLite", "📌 Registro encontrado: ID: " + idPrestamo +
                            ", Cliente ID: " + clienteId +
                            ", Dirección Cliente: " + direccionCliente +
                            ", Teléfono Cliente: " + telefonoCliente +
                            ", Ruta ID: " + rutaId +
                            ", Población ID: " + poblacionId +
                            ", Colocadora ID: " + colocadoraId +
                            ", Aval ID: " + avalId +
                            ", Grupo Población: " + grupoPoblacion +
                            ", Monto Prestado: " + montoPrestado +
                            ", Pago Semanal: " + pagoSemanal +
                            ", Fecha Préstamo: " + fechaPrestamo +
                            ", Modalidad Semanas: " + modalidadSemanas +
                            ", Número Tarjetón: " + numeroTarjeton +
                            ", Status: " + status +
                            ", Created At: " + createdAt +
                            ", Updated At: " + updatedAt);

                    // Ahora vamos a consultar los pagos de este préstamo
                    String consultaPagos = "SELECT * FROM pagos WHERE prestamo_id = ?";
                    Cursor cursorPagos = db.rawQuery(consultaPagos, new String[]{String.valueOf(idPrestamo)});

                    // Verificar si hay pagos asociados al préstamo
                    if (cursorPagos != null && cursorPagos.moveToFirst()) {
                        do {
                            int pagoId = cursorPagos.getInt(cursorPagos.getColumnIndexOrThrow("id"));
                            String cantidadEsperadaPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_esperada_pago"));
                            String cantidadNormalPagada = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_normal_pagada"));
                            String cantidadMulta = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_multa"));
                            String cantidadPendiente = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_pendiente"));
                            String cantidadTotalPagada = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("cantidad_total_pagada"));
                            String concepto = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("concepto"));
                            String fechaPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("fecha_pago"));
                            String fechaPagoRealizada = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("fecha_pago_realizada"));
                            String folio = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("folio"));
                            String semana = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("semana"));
                            String balance = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("balance"));
                            String empleadoId = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("empleado_id"));
                            String statusPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("status"));
                            String updatedAtPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("updated_at"));
                            String tipoPago = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("tipo_pago"));
                            String recuperado = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("recuperado"));
                            String sinc = cursorPagos.getString(cursorPagos.getColumnIndexOrThrow("sinc"));

                            // Log de los pagos asociados
                            Log.d("SQLite", "💰 Pago encontrado: ID: " + pagoId +
                                    ", Cantidad Esperada Pago: " + cantidadEsperadaPago +
                                    ", Cantidad Normal Pagada: " + cantidadNormalPagada +
                                    ", Cantidad Multa: " + cantidadMulta +
                                    ", Cantidad Pendiente: " + cantidadPendiente +
                                    ", Cantidad Total Pagada: " + cantidadTotalPagada +
                                    ", Concepto: " + concepto +
                                    ", Fecha Pago: " + fechaPago +
                                    ", Fecha Pago Realizada: " + fechaPagoRealizada +
                                    ", Folio: " + folio +
                                    ", Semana: " + semana +
                                    ", Balance: " + balance +
                                    ", Empleado ID: " + empleadoId +
                                    ", Status: " + statusPago +
                                    ", Updated At: " + updatedAtPago +
                                    ", Tipo Pago: " + tipoPago +
                                    ", Recuperado: " + recuperado +
                                    ", Sinc: " + sinc);

                        } while (cursorPagos.moveToNext());

                        cursorPagos.close(); // Cerrar cursor de pagos
                    } else {
                        Log.d("SQLite", "⚠️ No se encontraron pagos para el préstamo con ID: " + idPrestamo);
                    }

                } while (cursorTarjeton.moveToNext());

                cursorTarjeton.close(); // Cerrar cursor de préstamo
            } else {
                Log.d("SQLite", "⚠️ No se encontró un préstamo con Tarjetón 117801 en la base de datos.");
            }




            if (sesion.getString("nombre_perfil", "").equals("VOCERO") ||
                    sesion.getString("nombre_perfil", "").equals("Administrador") ||
                    sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {

                String fechaActual = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(new Date());
                Log.d("PagosWorker", "Fecha actual antes de actualizar: " + fechaActual);

                // Paso 1: Realizar un SELECT para verificar qué registros serán actualizados
                String selectQuery = "SELECT prestamos.id, prestamos.numero_tarjeton, pagos_max.ultima_fecha " +
                        "FROM prestamos " +
                        "JOIN ( " +
                        "   SELECT prestamo_id, MAX(fecha_pago) AS ultima_fecha " +
                        "   FROM pagos GROUP BY prestamo_id " +
                        ") pagos_max ON prestamos.id = pagos_max.prestamo_id " +
                        "WHERE DATE(pagos_max.ultima_fecha) < DATE('" + fechaActual + "') " +
                        "AND prestamos.status = 0";


                // Ejecutar la consulta SELECT
                Cursor cursor3 = db.rawQuery(selectQuery, null);
                StringBuilder idsAActualizar = new StringBuilder();
                while (cursor3.moveToNext()) {
                    String prestamoId = cursor3.getString(cursor3.getColumnIndexOrThrow("id"));
                    String numero_tarjeton2 = cursor3.getString(cursor3.getColumnIndexOrThrow("numero_tarjeton"));
                    String ultimaFecha = cursor3.getString(cursor3.getColumnIndexOrThrow("ultima_fecha"));

                    idsAActualizar.append(prestamoId).append(", ");

                }
                Log.d("PagosWorker", "IDs a actualizar en idsAActualizar: " + idsAActualizar.toString());

                cursor3.close();

                // Paso 2: Si hay registros que actualizar, realizar la actualización
                if (idsAActualizar.length() > 0) {
                    // Eliminar la última coma y espacio
                    idsAActualizar.setLength(idsAActualizar.length() - 2);

                    // Log de los IDs que van a ser actualizados
                    Log.d("PagosWorker", "Actualizando los registros: " + idsAActualizar.toString());

                    // Consulta de actualización
                    String updateQuery = "UPDATE prestamos SET status = -1 " +
                            "WHERE status = 0 AND id IN (" + idsAActualizar.toString() + ")";

                    // Ejecutar la actualización
                    db.execSQL(updateQuery);
                    Log.d("PagosWorker", "Actualización ejecutada.");
                } else {
                    Log.d("PagosWorker", "No hay registros para actualizar.");
                }
            }


            // Obtener el perfil del usuario
            String nombrePerfil = sesion.getString("nombre_perfil", "");
            boolean filtrarPendientes = nombrePerfil.equals("GESTOR") || nombrePerfil.equals("COBRADOR") || nombrePerfil.equals("JURIDICO");

            // Construir la consulta SQL con el filtro adicional si aplica
            // Construir la consulta SQL con el filtro adicional si aplica
            String query = "SELECT prestamos.id, prestamos.cliente_id, clientes.nombre_completo, clientes.direccion, " +
                    "clientes.telefono, clientes.garantias, prestamos.status, prestamos.fecha_prestamo, prestamos.monto_prestado, " +
                    "colocadoras.nombre_completo AS nombre_colocadora, avales.nombre_completo AS nombre_aval, avales.direccion AS direccion_aval, " +
                    "avales.telefono AS telefono_aval, rutas.nombre_ruta AS nombre_ruta, poblaciones.nombre_poblacion AS nombre_poblacion, " +
                    "poblaciones.monto_multa, configuracion_semanas.cantidad AS semanas, " +
                    "MAX(CASE WHEN pagos.fecha_pago = date('now') and pagos.semana = 14 and prestamos.modalidad_semanas = 1 and pagos.status = 0 THEN pagos.semana ELSE '0' END) as es_semana_14, " +
                    "MAX(CASE WHEN pagos.fecha_pago = date('now') and pagos.semana = 19 and prestamos.modalidad_semanas = 2 and pagos.status = 0 THEN pagos.semana ELSE '0' END) as es_semana_19, " +
                    "COUNT(CASE WHEN pagos.cantidad_pendiente != '0.00' THEN pagos.id END) as tiene_pendientes, " +
                    "COUNT(CASE WHEN pagos.status = 3 THEN pagos.id END) AS tiene_multas, " +
                    "COUNT(CASE WHEN pagos.folio is not null and pagos.folio != 0 THEN pagos.id END ) as tiene_folios, " +
                    "prestamos.created_at, prestamos.updated_at, " +
                    "prestamos.numero_tarjeton, " +
                    "prestamos.grupo_poblacion, " +
                    "avales.garantias AS garantias_aval, " +
                    "avales.otras_referencias  AS otras_referencias_aval, " +
                    "prestamos.pago_semanal, " +
                    "clientes.ruta_id, " +
                    "clientes.poblacion_id, " +
                    "prestamos.modalidad_semanas, " +
                    "prestamos.aval_id " +
                    "FROM prestamos " +
                    "JOIN clientes ON prestamos.cliente_id = clientes.id " +
                    "LEFT JOIN colocadoras ON clientes.colocadora_id = colocadoras.id " +
                    "LEFT JOIN avales ON prestamos.aval_id = avales.id " +
                    "LEFT JOIN rutas ON clientes.ruta_id = rutas.id " +
                    "LEFT JOIN poblaciones ON clientes.poblacion_id = poblaciones.id " +
                    "LEFT JOIN configuracion_semanas ON prestamos.modalidad_semanas = configuracion_semanas.id " +
                    "LEFT JOIN pagos ON prestamos.id = pagos.prestamo_id ";

            if (sesion.getString("nombre_perfil", "").equals("VOCERO") ||
                    sesion.getString("nombre_perfil", "").equals("Administrador") ||
                    sesion.getString("nombre_perfil", "").equals("ADMINISTRADOR")) {
                query += " AND prestamos.status NOT IN (1, 2, -1) ";
            }
            query += " GROUP BY prestamos.id ";
            if (filtrarPendientes) {
                query += "HAVING COUNT(CASE WHEN pagos.cantidad_pendiente != '0.00' THEN pagos.id END) > 0 ";
            }
            else {
                query += "HAVING COUNT(CASE WHEN pagos.status IN (0,-1) THEN pagos.id END) > 0 " +  // Al menos un pago con status 0
                        "OR COUNT(CASE WHEN pagos.cantidad_pendiente != '0.00' THEN pagos.id END) > 0 " +  // Al menos un pago con cantidad pendiente
                        "AND COUNT(CASE WHEN pagos.status NOT IN (1,3) THEN pagos.id END) = 0 ";  // Ningún pago con status distinto de 1 o 3
            }


            query += "ORDER BY prestamos.id DESC";


            // Ejecutar la consulta
            Cursor cursor = db.rawQuery(query, null);
            prestamos.clear(); // Limpiar lista en caso de recarga

            if (cursor != null && cursor.moveToFirst()) {
                List<Prestamo> prestamosBatch = new ArrayList<>(); // Lista temporal para el lote

                do {
                    String prestamoId = cursor.getString(cursor.getColumnIndexOrThrow("id"));
                    String clienteId = cursor.getString(cursor.getColumnIndexOrThrow("cliente_id"));
                    String prestamoStat = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                    String nombre_aval = cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval"));
                    String aval_id = cursor.getString(cursor.getColumnIndexOrThrow("aval_id"));
                    String numero_tarjeton = cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton"));
                    //Log.d("SQLite", "🔍 Ya existe en la base de datos: Tarjetón: " + numero_tarjeton);
                    String status = cursor.getString(cursor.getColumnIndexOrThrow("status"));
                    //Log.d("PrestamosWorker", "Total de préstamos añadidos en consulta BD............: ID: " + prestamoId + "/clienteId: "+ clienteId + "/prestamoStat: " + prestamoStat + "/aval_id: "+ aval_id + "/nombre_aval: "+ nombre_aval );
                    if (prestamoId != null && !prestamoId.isEmpty() && clienteId != null && !clienteId.isEmpty()) {
                        Prestamo prestamo = new Prestamo(
                                prestamoId,
                                clienteId,
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_completo")),
                                cursor.getString(cursor.getColumnIndexOrThrow("direccion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("telefono")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("garantias")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("status")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("status")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("fecha_prestamo")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("monto_prestado")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_colocadora")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("direccion_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("telefono_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_ruta")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("nombre_poblacion")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("monto_multa")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("monto_multa")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("semanas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("semanas")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("es_semana_14")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("es_semana_14")) : "0",
                                cursor.getString(cursor.getColumnIndexOrThrow("es_semana_19")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("es_semana_19")) : "0",
                                cursor.getString(cursor.getColumnIndexOrThrow("tiene_pendientes")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_pendientes")) : "0",
                                cursor.getString(cursor.getColumnIndexOrThrow("tiene_multas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_multas")) : "0",
                                cursor.getString(cursor.getColumnIndexOrThrow("tiene_folios")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("tiene_folios")) : "0",
                                cursor.getString(cursor.getColumnIndexOrThrow("created_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("created_at")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("updated_at")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("numero_tarjeton")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("grupo_poblacion")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("grupo_poblacion")) : "0",
                                cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("garantias_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("otras_referencias_aval")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("pago_semanal")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("ruta_id")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("poblacion_id")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("modalidad_semanas")) : "",
                                cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) != null ? cursor.getString(cursor.getColumnIndexOrThrow("aval_id")) : ""
                        );

                        prestamosBatch.add(prestamo); // Añadir a la lista temporal
                        //Log.e("SQLitePrestamos", "Prestamos Listas." + numero_tarjeton + "/ Status:"+status);
                    } else {
                        Log.e("SQLitePrestamos", "Registro con id o cliente_id nulo encontrado, omitiendo registro.");
                    }
                } while (cursor.moveToNext());

                prestamos.addAll(prestamosBatch); // Añadir todos los préstamos en lote
                Log.d("PrestamosWorker", "Total de préstamos añadidos: " + prestamosBatch.size());
                cursor.close();
            }
            db.close();

            Log.d("PrestamosWorker", "Total de registros en LISTA prestamos DESPUÉS DE CONSULTA FRAGMENT: " + prestamos);
            int totalRegistros = prestamos.size();
            Log.d("SQLitePrestamos", "Total de registros en SQLite EN CONSULTA SQL: " + totalRegistros);

            // Actualizar la UI si hay registros y la tarea se completó
            if (totalRegistros >= 0) {
                requireActivity().runOnUiThread(() -> {
                    updateUIWithPrestamos(prestamos);  // Actualizar la UI con los préstamos
                    progressDialogFragment.dismissAllowingStateLoss();  // Cerrar el ProgressDialog
                });
            } else {
                Log.d("PrestamosFragment", "No hay registros o la tarea no está completa.");
            }
            executor.shutdown();
        });
    }

    private void verificarConfiguracionSemanas(SQLiteDatabase db) {
        // Consulta SQL para obtener todos los registros de configuracion_semanas
        String query = "SELECT * FROM configuracion_semanas";
        Cursor cursor = db.rawQuery(query, null);

        if (cursor != null && cursor.moveToFirst()) {
            Log.d("ConfigSemanas", "Registros en la tabla configuracion_semanas:");
            do {
                int id = cursor.getInt(cursor.getColumnIndexOrThrow("id"));  // Reemplazar "id" con el nombre de la columna de ID si es diferente
                String cantidad = cursor.getString(cursor.getColumnIndexOrThrow("cantidad")); // Reemplazar "cantidad" si es necesario
                Log.d("ConfigSemanas", "ID: " + id + ", Cantidad: " + cantidad);
            } while (cursor.moveToNext());
            cursor.close();
        } else {
            Log.d("ConfigSemanas", "La tabla configuracion_semanas está vacía o no se pudo encontrar.");
        }
    }
    private void countPagosInSQLite(Context context, int threshold, CountPagosCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            int totalPagos = 0; // Inicializamos el conteo

            // Consulta para contar los registros en la tabla "Pagos"
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM pagos", null);

            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    totalPagos = cursor.getInt(0); // Obtiene el conteo de la primera columna
                }
                cursor.close(); // Cerrar el cursor
            }

            db.close(); // Cerrar la conexión a la base de datos

            Log.d("SQLite", "Total registros en PAGOS SQLite: " + totalPagos);

            // Devolver el resultado al hilo principal
            boolean result = totalPagos < threshold;
            getActivity().runOnUiThread(() -> {
                callback.onResult(result);  // Llamada al callback en el hilo principal
            });
            executor.shutdown();
        });
    }

    private void countPrestamosInSQLite(Context context, int threshold, CountPrestamosCallback callback) {
        ExecutorService executor = Executors.newSingleThreadExecutor();

        executor.execute(() -> {
            DatabaseHelper dbHelper = new DatabaseHelper(context);
            SQLiteDatabase db = dbHelper.getReadableDatabase();

            int totalPrestamos = 0; // Inicializamos el conteo

            // Consulta para contar los registros en la tabla "Prestamos"
            Cursor cursor = db.rawQuery("SELECT COUNT(*) FROM prestamos", null);

            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    totalPrestamos = cursor.getInt(0); // Obtiene el conteo de la primera columna
                }
                cursor.close(); // Cerrar el cursor
            }

            db.close(); // Cerrar la conexión a la base de datos

            Log.d("SQLite", "Total registros en PRESTAMOS SQLite: " + totalPrestamos);

            executor.shutdown();
            // Devolver el resultado al hilo principal
            boolean result = totalPrestamos < threshold;
            getActivity().runOnUiThread(() -> {
                callback.onResult(result);  // Llamada al callback en el hilo principal
            });

        });
    }

    private interface CountPagosCallback {
        void onResult(boolean result);
    }

    private interface CountPrestamosCallback {
        void onResult(boolean result);
    }

    // Método para verificar la conectividad de red
    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager) requireContext().getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    private void checkForUpdatesAndLoadCache() {
        if (PrestamosWorker.isTaskPrestamosCompleted) {
            Log.d("Prestamos", "Cargando PrestamosWorker.isTaskPrestamosCompleted: " + PrestamosWorker.isTaskPrestamosCompleted);
            cargarPrestamosDesdeSQLite();

            countPagosInSQLite(requireContext(), 3, new PrestamosFragment.CountPagosCallback() {
                @Override
                public void onResult(boolean result) {
                    // Si result es true, significa que hay menos de 2 registros en la tabla
                    if (result) {
                        PagosWorker.currentPagePagos = 0;
                        PagosWorker.allDataLoadedPagos = false;
                        PagosWorker.isTaskPagosCompleted = false;
                        PagosWorker.enqueueWork(requireContext());
                        getActivity().runOnUiThread(() -> {
                            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                                checkForUpdatesAndLoadCachePagos();
                            }, 2000);
                        });
                        Log.d("PAGOS", "Cargando enqueueWork PAGOS..... menos de 100 registros.");
                    } else {
                        Log.e("PagosWorker", "LISTA DE PRESTAMOS PARA PAGOS..................: " + PagosWorker.allPagos);

                        cargarPagosDesdeSQLite();

                        PagosWorker.currentPagePagos = 0;
                        PagosWorker.allDataLoadedPagos = true;
                        PagosWorker.isTaskPagosCompleted = false;
                        PagosWorker.enqueueWork(requireContext());
                        /*
                        getActivity().runOnUiThread(() -> {
                            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                                checkForUpdatesAndLoadCachePagos();
                            }, 2000);
                        });
                        */
                        Log.d("PAGOS", "MODO ACTUALIZAR: Cargando desde caché PAGOS..... más de 100 registros.");
                    }
                }
            });

            PrestamosWorker.isTaskPrestamosCompleted = false; // Reiniciar la bandera
            retryCount = 0; // Reiniciar contador
        } else {
            if (retryCount < MAX_RETRIES) {
                retryCount++;
                new Handler(Looper.getMainLooper()).postDelayed(this::checkForUpdatesAndLoadCache, 1000); // Verifica después de 1 segundo
            } else {
                Log.d("PRESTAMOS", "Número máximo de reintentos alcanzado. No se puede cargar la caché.");
                // Aquí puedes decidir qué hacer si no se completó la tarea
            }
        }
    }

    private void checkForUpdatesAndLoadCachePagos() {
        if (PagosWorker.isTaskPagosCompleted) {
            Log.d("Pagos", "Cargando PagosWorker.isTaskPagosCompleted: " + PagosWorker.isTaskPagosCompleted);
            cargarPagosDesdeSQLite();
            PagosWorker.isTaskPagosCompleted = false; // Reiniciar la bandera
            retryCountPagos = 0; // Reiniciar contador
        } else {
            if (retryCountPagos < MAX_RETRIES) {
                retryCountPagos++;
                Log.d("PRESTAMOS", "Número máximo de reintentos EN PAGOS...................................... " + retryCountPagos);
                Log.d("Pagos", "Número máximo de reintentos EN PAGOS.............................: " + PagosWorker.isTaskPagosCompleted);
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    checkForUpdatesAndLoadCachePagos();
                }, 1000); // Verifica después de 1 segundo
            } else {
                Log.d("PRESTAMOS", "Número máximo de reintentos alcanzado. No se puede cargar la caché.");
                cargarPagosDesdeSQLite();
            }
        }
    }

    private void pagoAdelantar(Prestamo prestamo, String tipo_pago) {
        VolleyS vs = VolleyS.getInstance(getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();

        try {
            data.put("func", "pagarSiguienteAdelantado");
            data.put("prestamo_id", prestamo.getId());
            data.put("empleado_id", sesion.getString("id", "0"));
            data.put("tipo_pago", tipo_pago);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String updatedAt = response.getJSONObject("data").getString("updated_at");
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                // Llamar al método de SQLite para actualizar el registro local
                                actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "4", sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "on", "", updatedAt);
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {
            @Override
            public void onErrorResponse(VolleyError error) {
                if (ErrorChecker.checker(error, getActivity()) == 1
                        || ErrorChecker.checker(error, getActivity()) == 4) {

                    actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "4", sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "off", "", "");

                    new MaterialAlertDialogBuilder(getActivity())
                            .setTitle("Aviso")
                            .setMessage("Se perdio la conexión y se guardarón los datos en local")
                            .setPositiveButton("Ok", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialogInterface, int i) {

                                }
                            })
                            .show();
                }
            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                3,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }
    private boolean isDialogShown = false;
    private void pagar(Prestamo prestamo, String tipo_pago) {

        VolleyS vs = VolleyS.getInstance(getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();

        if (sesion.getString("nombre_perfil", "").equals("COBRADOR")
                || sesion.getString("nombre_perfil", "").equals("GESTOR")) {

            try {
                data.put("func", "pagarSiguiente");
                data.put("prestamo_id", prestamo.getId());
                data.put("statusPago", "-1");
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);

            } catch (JSONException e) {
                e.printStackTrace();
            }

        } else {

            try {
                data.put("func", "pagarSiguiente");
                data.put("prestamo_id", prestamo.getId());
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);

            } catch (JSONException e) {
                e.printStackTrace();
            }

        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String updatedAt = response.getJSONObject("data").getString("updated_at");
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                // Llamar al método de SQLite para actualizar el registro local
                                if (sesion.getString("nombre_perfil", "").equals("COBRADOR")
                                        || sesion.getString("nombre_perfil", "").equals("GESTOR")) {
                                    actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "-1", sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "on", "", updatedAt);
                                }
                                else
                                {
                                    actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "1", sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "on", "", updatedAt);
                                }
                                // Mostrar el diálogo solo si no se ha mostrado antes
                                if (!isDialogShown) {
                                    isDialogShown = true; // Marcar como mostrado

                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getContext());
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> {
                                        confirmationDialog.dismiss();
                                        isDialogShown = false; // Reiniciar la variable después de cerrar el diálogo
                                    }, 3000);
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                if (ErrorChecker.checker(error, getActivity()) == 1
                        || ErrorChecker.checker(error, getActivity()) == 4) {
                    if (sesion.getString("nombre_perfil", "").equals("COBRADOR")
                            || sesion.getString("nombre_perfil", "").equals("GESTOR")) {
                        actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "1", sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "off", "", "");
                    }
                    else
                    {
                        actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "1", sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "0.00", "", "off", "", "");
                    }
                    if (!isDialogShown) {
                        isDialogShown = true; // Marcar como mostrado
                        // Crear un MaterialAlertDialog personalizado
                        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                        View dialogView = inflater.inflate(R.layout.dialog_success, null);

                        // Encuentra el TextView y asigna el texto dinámico
                        TextView messageText = dialogView.findViewById(R.id.message_text);
                        messageText.setText("Se perdio la conexión y se guardarón los datos en local"); // Texto dinámico

                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getContext());
                        builder.setView(dialogView); // Usa el layout personalizado

                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();

                        // Cerrar automáticamente el diálogo después de 3 segundos
                        new Handler().postDelayed(() -> {
                            confirmationDialog.dismiss();
                            isDialogShown = false; // Reiniciar la variable después de cerrar el diálogo
                        }, 3000);
                    }

                }

            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                3,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);

    }
    @SuppressLint("Range")
    private void actualizarPagoEnSQLite(Prestamo prestamo, int prestamo_id, String semana, String tipo_pago, String status, String empleado_id, String concepto, String pagoSemanal, String pagoMultaLocal, String tipo_p, String off, String folio, String updatedAt) {
        DatabaseHelper dbHelper = new DatabaseHelper(requireContext());
        SQLiteDatabase db = dbHelper.getWritableDatabase();

        // Si semana está vacía, calcular la próxima semana no pagada
        if (semana == null || semana.isEmpty()) {
            String query = "SELECT semana FROM pagos WHERE prestamo_id = ? AND status == '0' ORDER BY CAST(semana AS INTEGER) ASC LIMIT 1";
            Cursor cursor = db.rawQuery(query, new String[]{String.valueOf(prestamo_id)});

            if (cursor != null && cursor.moveToFirst()) {
                semana = cursor.getString(cursor.getColumnIndex("semana"));
                Log.d("SQLite", "Semanas pendientes para este préstamo." + semana);
                cursor.close();
            } else {
                // Si no hay semanas no pagadas, puedes manejarlo según tu lógica (por ejemplo, establecer un valor predeterminado o lanzar un error)
                Log.d("SQLite", "No hay semanas pendientes para este préstamo.");
                semana = null; // o manejar como prefieras
            }
        }

        // Crear los valores a actualizar
        ContentValues valores = new ContentValues();
        valores.put("prestamo_id", prestamo_id);
        valores.put("semana", semana);
        valores.put("tipo_pago", tipo_pago);
        valores.put("status", status);
        valores.put("empleado_id", empleado_id);
        valores.put("concepto", concepto);
        valores.put("cantidad_multa", pagoMultaLocal);
        if(!folio.isEmpty())
        {
            valores.put("folio", folio);
        }
        else
        {
            valores.put("folio", "0");
        }
        // Obtener el timestamp actual y formatearlo
        long timestamp = System.currentTimeMillis();

        if(off.equals("off"))
        {
            valores.put("sinc", "1");
            Log.d("PrestamosFragment", "ENTRO EN MODO OFFLINE EL PAGO.......");
            // SUMAR 10 segundos (10,000 milisegundos)
            timestamp += 10000; // 10 segundos = 30,000 milisegundos
        }
        else
        {
            Log.d("PrestamosFragment", "ENTRO EN MODO CON CONEXION EL PAGO.......: ");
            timestamp -= 10000; // 10 segundos = 30,000 milisegundos
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate = sdf.format(new Date(timestamp));
        // Formatear la nueva hora

        valores.put("updated_at", formattedDate);
        if(!updatedAt.equals("") )
        {
            Log.d("PrestamosFragment", "ENTRO EN MODO CON CONEXION EL PAGO + regreso el tiempo del servidor.......: " + updatedAt);
            valores.put("updated_at", updatedAt);
        }

        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", new Locale("es", "MX"));
        String formattedDate2 = sdf2.format(new Date(timestamp));
        valores.put("fecha_pago_realizada", formattedDate2);

        // Obtener el valor actual de "cantidad_normal_pagada" como String desde la base de datos
        String cantidadNormalExistenteStr = "#.00";
        String queryNormal = "SELECT cantidad_normal_pagada FROM pagos WHERE prestamo_id = ? AND semana = ?";
        Cursor cursorNormal = db.rawQuery(queryNormal, new String[]{String.valueOf(prestamo_id), semana});

        if (cursorNormal.moveToFirst()) {
            cantidadNormalExistenteStr = cursorNormal.getString(cursorNormal.getColumnIndex("cantidad_normal_pagada"));
        }
        cursorNormal.close();

        // Convertir y sumar el nuevo valor de "cantidad_normal_pagada"
        double cantidadNormalExistente = Utils.convertirDouble(cantidadNormalExistenteStr);
        double cantidadPagada = Utils.convertirDouble(pagoSemanal);
        double nuevaCantidadNormalPagada = cantidadNormalExistente + cantidadPagada;

        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String pagoNormalTotCantidad = decimalFormat.format(nuevaCantidadNormalPagada);
        valores.put("cantidad_normal_pagada", pagoNormalTotCantidad);
        valores.put("recuperado", pagoNormalTotCantidad);

        // Obtener el valor actual de "cantidad_total_pagada" como String y convertir a double
        String cantidadTotalExistenteStr = "0.00";
        String queryTotal = "SELECT cantidad_total_pagada FROM pagos WHERE prestamo_id = ? AND semana = ?";
        Cursor cursorTotal = db.rawQuery(queryTotal, new String[]{String.valueOf(prestamo_id), semana});

        if (cursorTotal.moveToFirst()) {
            cantidadTotalExistenteStr = cursorTotal.getString(cursorTotal.getColumnIndex("cantidad_total_pagada"));
        }
        cursorTotal.close();

        // Convertir a double y sumar el nuevo total al valor existente
        double cantidadTotalExistente = Utils.convertirDouble(cantidadTotalExistenteStr);
        double pagoTotalNuevo = Utils.convertirDouble(pagoNormalTotCantidad) + Utils.convertirDouble(pagoMultaLocal);
        double nuevaCantidadTotalPagada = pagoTotalNuevo;

        String pagoTotCantidad = decimalFormat.format(nuevaCantidadTotalPagada);

        valores.put("cantidad_total_pagada", pagoTotCantidad);
        valores.put("recuperado", pagoTotCantidad);
        // Calcular y actualizar "cantidad_pendiente" si el pago es menor a lo debido
        double pago_semana = Utils.convertirDouble(prestamo.getPago_semanal());
        double pendiente_final = pago_semana - nuevaCantidadNormalPagada;

        if (pendiente_final > 0) {
            String pagoPenCantidad = decimalFormat.format(pendiente_final);
            valores.put("cantidad_pendiente", pagoPenCantidad);
        } else {
            valores.put("cantidad_pendiente", "0.00");
        }
        ////////////CONDICION PARA OMITIR SEMANA 15 O 20 Y CAMBIAR ESTATUS DE PRESTAMO//////////////////
        int tiene_multas = Integer.parseInt(prestamo.getTiene_multas());
        int tiene_pendientes = Integer.parseInt(prestamo.getTiene_pendientes());
        int tiene_folios = Integer.parseInt(prestamo.getTiene_folios());

        if ("14".equals(semana) || "19".equals(semana) || "15".equals(semana) || "20".equals(semana)) {
            Log.d("DEBUG", "Semana coincide con 14 o 19");
            if (tiene_multas==0 && tiene_pendientes==0 && tiene_folios==0)
            {
                String ultimaSemana = "14".equals(semana) ? "15" : "20";

                // Crear un DecimalFormat para asegurar que el valor tenga 2 decimales
                DecimalFormat decimalFormat4 = new DecimalFormat("#.00");

                // Formatear cantidadPagada para que siempre tenga 2 decimales
                String cantidadPagadaFormatted = decimalFormat4.format(cantidadPagada);

                ContentValues valoresUltimaSemana = new ContentValues();
                valoresUltimaSemana.put("prestamo_id", prestamo_id);
                valoresUltimaSemana.put("semana", ultimaSemana);
                valoresUltimaSemana.put("status", "2");
                valoresUltimaSemana.put("empleado_id", empleado_id);
                valoresUltimaSemana.put("concepto", "Semana omitida");
                valoresUltimaSemana.put("cantidad_normal_pagada", cantidadPagadaFormatted);
                valoresUltimaSemana.put("cantidad_total_pagada", cantidadPagadaFormatted);
                valoresUltimaSemana.put("recuperado", cantidadPagadaFormatted);
                valoresUltimaSemana.put("updated_at", formattedDate);
                valoresUltimaSemana.put("fecha_pago_realizada", formattedDate2);

                long insertResult = db.update("pagos", valoresUltimaSemana, "prestamo_id = ? AND semana = ?", new String[]{String.valueOf(prestamo_id), ultimaSemana});

                if (insertResult != -1) {
                    Log.d("SQLite", "Registro insertado en la última semana de pago con status 2: Semana " + ultimaSemana);

                    // Si la inserción fue exitosa, actualizar el status del préstamo en la tabla `prestamos` a 1
                    ContentValues valoresPrestamo = new ContentValues();
                    valoresPrestamo.put("status", "1");

                    int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{String.valueOf(prestamo_id)});
                    if (updatePrestamoResult > 0) {
                        Log.d("SQLite", "Status del préstamo actualizado a 1 para prestamo_id: " + prestamo_id);
                    } else {
                        Log.d("SQLite", "Error al actualizar el status del préstamo para prestamo_id: " + prestamo_id);
                    }
                } else {
                    Log.d("SQLite", "Error al insertar registro en la última semana de pago");
                }
            }
            if (tiene_pendientes==0 || "15".equals(semana) || "20".equals(semana)) {
                ContentValues valoresPrestamo = new ContentValues();
                valoresPrestamo.put("status", "1");

                int updatePrestamoResult = db.update("prestamos", valoresPrestamo, "id = ?", new String[]{String.valueOf(prestamo_id)});
                if (updatePrestamoResult > 0) {
                    Log.d("SQLite", "Status del préstamo actualizado a 1 para prestamo_id: " + prestamo_id);
                } else {
                    Log.d("SQLite", "Error al actualizar el status del préstamo para prestamo_id: " + prestamo_id);
                }
            }
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////

        // Actualizar el registro en la tabla `pagos`
        int filasActualizadas = db.update("pagos", valores, "prestamo_id = ? AND semana = ?", new String[]{String.valueOf(prestamo_id), semana});

        if (filasActualizadas > 0) {
            //Log.d("SQLite", "Pago actualizado correctamente en SQLite para prestamo_id: " + prestamo_id + ", semana: " + semana);
        } else {
            //Log.d("SQLite", "No se pudo actualizar el pago en SQLite para prestamo_id: " + prestamo_id + ", semana: " + semana);
        }

        db.close(); // Cerrar la conexión a la base de datos
    }
    private void pagarConMulta(Prestamo prestamo, String tipo_pago) {
        VolleyS vs = VolleyS.getInstance(getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();


        if (sesion.getString("nombre_perfil", "").equals("COBRADOR")
                || sesion.getString("nombre_perfil", "").equals("GESTOR")) {

            try {
                data.put("func", "pagarSiguienteConMulta");
                data.put("prestamo_id", prestamo.getId());
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);
            } catch (JSONException e) {
                e.printStackTrace();
            }

        } else {

            try {
                data.put("func", "pagarSiguienteConMulta");
                data.put("prestamo_id", prestamo.getId());
                data.put("statusPago", "0");
                data.put("empleado_id", sesion.getString("id", "0"));
                data.put("tipo_pago", tipo_pago);
            } catch (JSONException e) {
                e.printStackTrace();
            }

        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String updatedAt = response.getJSONObject("data").getString("updated_at");
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "3", sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "50.00", tipo_pago, "on", "", updatedAt);

                                // Mostrar el diálogo solo si no se ha mostrado antes
                                if (!isDialogShown) {
                                    isDialogShown = true; // Marcar como mostrado

                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getContext());
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> {
                                        confirmationDialog.dismiss();
                                        isDialogShown = false; // Reiniciar la variable después de cerrar el diálogo
                                    }, 3000);
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, error -> {

            if (ErrorChecker.checker(error, getActivity()) == 1
                    || ErrorChecker.checker(error, getActivity()) == 4) {
                actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", tipo_pago, "3", sesion.getString("id", "0"), "", prestamo.getPago_semanal(), "50.00", tipo_pago, "off", "", "");
                if (!isDialogShown) {
                    // Crear un MaterialAlertDialog personalizado
                    LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                    // Encuentra el TextView y asigna el texto dinámico
                    TextView messageText = dialogView.findViewById(R.id.message_text);
                    messageText.setText("Se perdio la conexión y se guardarón los datos en local"); // Texto dinámico

                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getContext());
                    builder.setView(dialogView); // Usa el layout personalizado

                    AlertDialog confirmationDialog = builder.create();
                    confirmationDialog.show();

                    // Cerrar automáticamente el diálogo después de 3 segundos
                    new Handler().postDelayed(() -> {
                        confirmationDialog.dismiss();
                        isDialogShown = false; // Reiniciar la variable después de cerrar el diálogo
                    }, 3000);
                }
            }

        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                10000,
                1,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);

    }

    private void noPagar(Prestamo prestamo) {
        VolleyS vs = VolleyS.getInstance(getActivity());
        RequestQueue requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "noPagarSiguiente");
            data.put("prestamo_id", prestamo.getId());
            data.put("empleado_id", sesion.getString("id", "0"));
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPagos, data,
                new Response.Listener<JSONObject>() {
                    @Override
                    public void onResponse(JSONObject response) {
                        try {
                            if (response.getString("status").equals("success")) {
                                // Obtener el campo updated_at del servidor
                                String updatedAt = response.getJSONObject("data").getString("updated_at");
                                Log.d("DEBUG", "Respuesta JSON contiene 'data de updated_at'....................: " + updatedAt);
                                // Llamar al método de SQLite para actualizar el registro local
                                actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", "", "-1", sesion.getString("id", "0"), "", "0.00", "0.00", "", "on", "", updatedAt);

                                // Mostrar el diálogo solo si no se ha mostrado antes
                                if (!isDialogShown) {
                                    isDialogShown = true; // Marcar como mostrado

                                    // Crear un MaterialAlertDialog personalizado
                                    LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                                    View dialogView = inflater.inflate(R.layout.dialog_success, null);

                                    // Encuentra el TextView y asigna el texto dinámico
                                    TextView messageText = dialogView.findViewById(R.id.message_text);
                                    messageText.setText("Se ingresaron los datos correctamente."); // Texto dinámico

                                    MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getContext());
                                    builder.setView(dialogView); // Usa el layout personalizado

                                    AlertDialog confirmationDialog = builder.create();
                                    confirmationDialog.show();

                                    // Cerrar automáticamente el diálogo después de 3 segundos
                                    new Handler().postDelayed(() -> {
                                        confirmationDialog.dismiss();
                                        isDialogShown = false; // Reiniciar la variable después de cerrar el diálogo
                                    }, 3000);
                                }
                            }
                        } catch (JSONException e) {
                            e.printStackTrace();
                        }

                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                if (ErrorChecker.checker(error, getActivity()) == 1
                        || ErrorChecker.checker(error, getActivity()) == 4) {

                    actualizarPagoEnSQLite(prestamo, Integer.parseInt(prestamo.getId()), "", "", "-1", sesion.getString("id", "0"), "", "0.00", "0.00", "", "off", "", "");
                    if (!isDialogShown) {
                        // Crear un MaterialAlertDialog personalizado
                        LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                        View dialogView = inflater.inflate(R.layout.dialog_success, null);

                        // Encuentra el TextView y asigna el texto dinámico
                        TextView messageText = dialogView.findViewById(R.id.message_text);
                        messageText.setText("Se perdio la conexión y se guardarón los datos en local"); // Texto dinámico

                        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(getContext());
                        builder.setView(dialogView); // Usa el layout personalizado

                        AlertDialog confirmationDialog = builder.create();
                        confirmationDialog.show();

                        // Cerrar automáticamente el diálogo después de 3 segundos
                        new Handler().postDelayed(() -> {
                            confirmationDialog.dismiss();
                            isDialogShown = false; // Reiniciar la variable después de cerrar el diálogo
                        }, 3000);
                    }
                }

            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                3,
                //DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);

    }
    public static void updateUIWithPrestamos(List<Prestamo> prestamos2) {

        if (prestamosAdapter == null) {
            Log.e("PrestamosFragment", "prestamosAdapter es nulo.");
            return; // No debería ser nulo, pero por precaución
        }

            /*
               if (prestamo.getTiene_pendientes()
            */

            if (prestamosAdapter != null && prestamos != null) {
                prestamosAdapter.setListaFiltrada(prestamos);
                prestamosAdapter.notifyDataSetChanged();
            }

            if (shimmer != null && shimmer.getVisibility() == View.VISIBLE) {
                Log.d("PrestamosFragment", "Deteniendo el shimmer...");
                stopShimmer();
                isShimmerActive = false;
            }

            if (recyclerView != null) {
                recyclerView.setVisibility(View.VISIBLE);
            }
    }

    public void refreshData(String modalidadId) {
        if (getParentFragmentManager().findFragmentByTag("progressDialog") == null) {
            progressDialogFragment = new ProgressDialogFragment();
            progressDialogFragment.setMessage("Sincronizando información...");
            progressDialogFragment.show(getParentFragmentManager(), "progressDialog");
        }

        WorkManager workManager = WorkManager.getInstance(requireContext());
        workManager.cancelAllWorkByTag("PrestamosWorker");
        workManager.cancelAllWorkByTag("PagosWorker");

        retryCountPagos=0;
        retryCount=0;
        prestamos.clear();
        prestamosAdapter.clear();
        pagos.clear();
        PrestamosWorker.currentPagePrestamos = 0;
        PrestamosWorker.allDataLoadedPrestamos = false;
        PrestamosWorker.isTaskPrestamosCompleted = false;
        PagosWorker.isTaskPagosCompleted = false;
        PagosWorker.allDataLoadedPagos = false;
        PrestamosWorker.enqueueWork(requireContext());
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
            @Override
            public void run() {
                checkForUpdatesAndLoadCache();
            }
        }, 1000);
        //isPollingActive = false;
        //loadedIds.clear(); // Limpia el set de IDs cargados
        modalidad_id = "1";
        ruta_id = "";
        rutasAutoCompleteTextView.setText("");

        poblacion_id = "";
        poblacionesAutoCompleteTextView.setText("");

        svPrestamos.setText("");
        //applyFilters();
    }
    private NetworkChangeReceiver networkChangeReceiver;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        networkChangeReceiver = new NetworkChangeReceiver(this);
    }

    @Override
    public void onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION);
        getActivity().registerReceiver(networkChangeReceiver, filter);
    }

    @Override
    public void onStop() {
        super.onStop();
        getActivity().unregisterReceiver(networkChangeReceiver); // Detener la recepción de cambios de red
        //stopPolling(); // Detener el polling al salir del fragmento
        if (speedChecker != null) {
            speedChecker.stopChecking();
        }
        isSessionActive = false;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (speedChecker != null) {
            speedChecker.stopChecking();
        }
        //stopPolling();
        isSessionActive = false;
    }
    @Override
    public void onNetworkChanged(boolean isConnected) {
        this.isConnected = isConnected;
        if (speedChecker == null) {
            speedChecker = new NetworkSpeedChecker(getActivity(), textViewMensajes);
        }

        if (isConnected) {
            speedChecker.startChecking();
            /*
            PrestamosWorker.isTaskPrestamosCompleted = false;
            PagosWorker.isTaskPagosCompleted = false;
            PrestamosWorker.enqueueWork(requireContext());
            checkForUpdatesAndLoadCache();
            */
            isSessionActive = true;
            if (textViewMensajes != null) {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("");
            }
        } else {
            isSessionActive = false;
            //stopPolling(); // Detener el polling si no hay conexión
            shouldStartPolling = true; // Habilitar reinicio del polling cuando se restablezca la conexión
            if (textViewMensajes != null) {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("¡SIN INTERNET!");
            }
            if (speedChecker != null) {
                speedChecker.stopChecking();
            }
            speedChecker.stopChecking();
        }
    }

    private void hideTextViewAfterDelay() {
        if (textViewMensajes != null && textViewMensajes.getVisibility() == View.VISIBLE) {
            new Handler(Looper.getMainLooper()).postDelayed(() -> {
                textViewMensajes.setVisibility(View.VISIBLE);
                textViewMensajes.setText("");
            }, 3000);
        }
    }

    private static boolean isSessionActive = true; // Variable para verificar si la sesión está activa

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        isSessionActive = false; // Marcar la sesión como no activa al destruir la vista del fragmento
    }

    public static void applyFilters() {
        String texto = svPrestamos.getText().toString();
        if (!modalidad_id.equals("") && svPrestamos != null && !ruta_id.equals("") && !poblacion_id.equals("")) {
            filtrarPrestamos(modalidad_id, ruta_id, poblacion_id, texto);
            Log.d("PRESTAMOS", "filtro: " + modalidad_id +"/"+ruta_id+"/"+poblacion_id+"/"+texto);
        } else if (!modalidad_id.equals("") && !ruta_id.equals("") && !poblacion_id.equals("")) {
            filtrarPrestamos(modalidad_id, ruta_id, poblacion_id);
            Log.d("PRESTAMOS", "filtro: " + modalidad_id +"/"+ruta_id+"/"+poblacion_id);
        } else if (!modalidad_id.equals("") && !ruta_id.equals("")) {
            filtrarPrestamos(modalidad_id, ruta_id, "");
            Log.d("PRESTAMOS", "filtro: " + modalidad_id +"/"+ruta_id);
        } else if (!modalidad_id.equals("")) {
            filtrarPrestamos(modalidad_id);
            Log.d("PRESTAMOS", "filtro: " + modalidad_id);
        } else if (!modalidad_id.equals("") && svPrestamos != null) {
            filtrarPrestamos(modalidad_id, texto);
            Log.d("PRESTAMOS", "filtro: " + modalidad_id+"/"+texto);
        }
    }
    private void getModalidades() {
        Modalidad modalidad20 = new Modalidad();
        modalidad20.setId("2");
        modalidad20.setCantidad("20");
        Modalidad modalidad15 = new Modalidad();
        modalidad15.setId("1");
        modalidad15.setCantidad("15");

        modalidades.add(modalidad15);
        modalidades.add(modalidad20);

        modalidadesAdapter = new ArrayAdapter<Modalidad>(getContext(), android.R.layout.simple_dropdown_item_1line, modalidades);
        modalidadesAutoCompleteTextView.setThreshold(1);
        modalidadesAutoCompleteTextView.setAdapter(modalidadesAdapter);
    }

    public void getRutas() {
        // Obtener el ruta_id de la sesión
        String rutaIdSesion = sesion.getString("rutas", "");
        Log.d("getRutas", "Ruta ID de la sesión: " + rutaIdSesion);

        // Descomponer los IDs de la sesión en una lista
        List<String> rutaIdsSesion = Arrays.asList(rutaIdSesion.split(","));
        Log.d("getRutas", "Ruta IDs de la sesión descompuestos: " + rutaIdsSesion);

        // Verificar si ya tenemos rutas guardadas localmente
        if (rutaController.obtener().size() == 0) {
            Log.d("getRutas", "No se encontraron rutas guardadas localmente. Solicitando desde el servidor.");

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "rutasActivas");
                Log.d("getRutas", "JSON enviado al servidor: " + data.toString());
            } catch (JSONException e) {
                e.printStackTrace();
                Log.e("getRutas", "Error al crear JSON: " + e.getMessage());
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlRutas, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            Log.d("getRutas", "Respuesta del servidor: " + response.toString());
                            try {
                                JSONArray data = response.getJSONArray("data");
                                Log.d("getRutas", "Cantidad de rutas recibidas: " + data.length());

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    Log.d("getRutas", "Ruta JSON recibida: " + obj.toString());

                                    Gson gson = new Gson();
                                    Ruta ruta = gson.fromJson(obj.toString(), Ruta.class);

                                    // Filtrar rutas para que solo se incluyan aquellas con el ruta_id de la sesión
                                    if (rutaIdsSesion.contains(ruta.getId())) {
                                        rutas.add(ruta);
                                        rutaController.nueva(ruta);
                                        Log.d("getRutas", "Ruta añadida: " + ruta.toString());
                                    }
                                }

                                // Crear y configurar el adaptador solo con las rutas filtradas
                                rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
                                rutasAutoCompleteTextView.setThreshold(1);
                                rutasAutoCompleteTextView.setAdapter(rutasAdapter);
                                Log.d("getRutas", "Adaptador configurado con " + rutas.size() + " rutas.");

                            } catch (JSONException e) {
                                e.printStackTrace();
                                Log.e("getRutas", "Error al procesar respuesta del servidor: " + e.getMessage());
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.e("getRutas", "Error en la solicitud de rutas: " + error.getMessage());
                    ErrorChecker.checker(error, getActivity());
                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    3,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
            Log.d("getRutas", "Solicitud enviada al servidor.");
        } else {
            // Recuperar las rutas de la base de datos local y filtrar por los IDs en la sesión
            Log.d("getRutas", "Recuperando rutas guardadas localmente.");
            List<Ruta> rutasGuardadas = rutaController.obtener();
            Log.d("getRutas", "Cantidad de rutas locales encontradas: " + rutasGuardadas.size());

            for (Ruta ruta : rutasGuardadas) {
                Log.d("getRutas", "Ruta local encontrada: " + ruta.toString());
                // Verificar si el ID de la ruta está en la lista de IDs de la sesión
                if (rutaIdsSesion.contains(ruta.getId())) {
                    rutas.add(ruta);
                    Log.d("getRutas", "Ruta añadida tras filtrar: " + ruta);
                }
            }

            // Crear y configurar el adaptador solo con las rutas filtradas
            rutasAdapter = new ArrayAdapter<>(getContext(), android.R.layout.simple_dropdown_item_1line, rutas);
            rutasAutoCompleteTextView.setThreshold(1);
            rutasAutoCompleteTextView.setAdapter(rutasAdapter);
            Log.d("getRutas", "Adaptador configurado con " + rutas.size() + " rutas locales.");
        }
    }




    private void getPoblaciones(String ruta_id) {
        if (poblacionController.obtener().size() == 0) {

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "index");

            } catch (JSONException e) {
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                    new Response.Listener<JSONObject>() {

                        @Override
                        public void onResponse(JSONObject response) {
                            try {

                                JSONArray data = (JSONArray) response.get("data");

                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Poblacion poblacion = gson.fromJson(obj.toString(), Poblacion.class);

                                    poblaciones.add(poblacion);
                                    poblacionController.nueva(poblacion);

                                }

                                poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
                                poblacionesAutoCompleteTextView.setThreshold(1);
                                poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

                            } catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {

                @Override
                public void onErrorResponse(VolleyError error) {

                    ErrorChecker.checker(error, getActivity());

                }
            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    30000,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {

            poblaciones = poblacionController.obtener();

            poblacionesAdapter = new ArrayAdapter<Poblacion>(getContext(), android.R.layout.simple_dropdown_item_1line, poblaciones);
            poblacionesAutoCompleteTextView.setThreshold(1);
            poblacionesAutoCompleteTextView.setAdapter(poblacionesAdapter);

        }
    }

    private void getGrupos() {
        vs = VolleyS.getInstance(this.getContext());
        requestQueue = vs.getRequestQueue();

        JSONObject data = new JSONObject();
        try {
            data.put("func", "grupos");
        } catch (JSONException e) {
            e.printStackTrace();
        }

        JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPoblaciones, data,
                new Response.Listener<JSONObject>() {

                    @Override
                    public void onResponse(JSONObject response) {
                        try {

                            JSONArray data = (JSONArray) response.get("data");

                            if (data.length() > 0) {
                                for (int i = 0; i < data.length(); i++) {

                                    JSONObject obj = data.getJSONObject(i);

                                    Gson gson = new Gson();
                                    Grupo grupo = gson.fromJson(obj.toString(), Grupo.class);

                                    grupos.add(grupo);

                                }

                            } else {
                                Toast.makeText(getActivity(), "La población seleccionada no tiene grupos", Toast.LENGTH_SHORT).show();
                            }


                        } catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }, new Response.ErrorListener() {

            @Override
            public void onErrorResponse(VolleyError error) {

                ErrorChecker.checker(error, getActivity());

            }
        });

        request.setRetryPolicy(new DefaultRetryPolicy(
                30000,
                DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

        requestQueue.add(request);
    }


    private void filtrarPrestamosBusqueda(String text) {

        prestamosFiltrados = new ArrayList<>();
        prestamosFiltrados.clear();
        if (prestamosFiltrados.size() == 0) {

            for (Prestamo prestamo : prestamos) {
                String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
                if (prestamo.getNumero_tarjeton().toLowerCase().contains(text.toLowerCase()) || prestamo.getNombre_completo().toLowerCase().contains(text.toLowerCase()) || texto_filtro.toLowerCase().contains(text.toLowerCase())) {
                    prestamosFiltrados.add(prestamo);
                }
            }

            if (!prestamosFiltrados.isEmpty()) {
                prestamosAdapter.setListaFiltrada(prestamosFiltrados);
            }

        } else {
            prestamosFiltradosNombres = new ArrayList<>();

            for (Prestamo prestamo : prestamosFiltrados) {
                String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
                if (prestamo.getNumero_tarjeton().toLowerCase().contains(text.toLowerCase()) || prestamo.getNombre_completo().toLowerCase().contains(text.toLowerCase()) || texto_filtro.toLowerCase().contains(text.toLowerCase())) {
                    prestamosFiltradosNombres.add(prestamo);
                }
            }

            if (!prestamosFiltradosNombres.isEmpty()) {
                prestamosAdapter.setListaFiltrada(prestamosFiltradosNombres);
            }
        }

    }
    private static void filtrarPrestamos(String modalidad_id, String ruta_id, String poblacion_id, String text) {
        prestamosFiltrados = new ArrayList<>();
        //Log.d("DEBUG", "El modalidad: " + modalidad_id + "La ruta: " + ruta_id + "La poblacion: " + poblacion_id + "La text: " + poblacion_id);
        for (Prestamo prestamo : prestamos) {
            String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
            boolean cumpleCondiciones = prestamo.getModalidad_semanas().equals(modalidad_id) &&
                    prestamo.getRuta_id().equals(ruta_id) &&
                    prestamo.getPoblacion_id().equals(poblacion_id);

            if (!text.isEmpty()) {
                cumpleCondiciones = cumpleCondiciones && prestamo.getNombre_completo().toLowerCase().contains(text.toLowerCase()) || texto_filtro.toLowerCase().contains(text.toLowerCase());
            }

            if (cumpleCondiciones) {
                prestamosFiltrados.add(prestamo);
            }
        }

        if (!prestamosFiltrados.isEmpty()) {
            prestamosAdapter.setListaFiltrada(prestamosFiltrados);
        } else {
            // Si no hay coincidencias, puedes manejarlo aquí, por ejemplo, mostrando una lista en blanco
            prestamosAdapter.setListaFiltrada(new ArrayList<>());
        }
    }
    private static void filtrarPrestamos(String modalidad_id) {

        prestamosFiltrados = new ArrayList<>();
        prestamosFiltrados.clear();

        for (Prestamo prestamo : prestamos) {
            String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
            if (prestamo.getModalidad_semanas().equals(modalidad_id)
            ) {
                prestamosFiltrados.add(prestamo);
            }
        }

        if (!prestamosFiltrados.isEmpty()) {
            prestamosAdapter.setListaFiltrada(prestamosFiltrados);
        } else {

        }

    }

    private static void filtrarPrestamos(String modalidad_id, String ruta_id, String text) {

        prestamosFiltrados = new ArrayList<>();
        prestamosFiltrados.clear();

        for (Prestamo prestamo : prestamos) {
            String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
            if (prestamo.getModalidad_semanas().equals(modalidad_id) &&
                    prestamo.getRuta_id().equals(ruta_id)
            )
            {
                prestamosFiltrados.add(prestamo);
            }
        }

        if (!prestamosFiltrados.isEmpty()) {
            prestamosAdapter.setListaFiltrada(prestamosFiltrados);
        } else {

        }
    }

    private static void filtrarPrestamos(String modalidad_id, String text) {

        prestamosFiltrados.clear();
        prestamosFiltrados = new ArrayList<>();
        prestamosFiltrados.clear();

        for (Prestamo prestamo : prestamos) {
            String texto_filtro = prestamo.getCliente_id() + "\nAVAL: " + prestamo.getNombre_aval();
            if (prestamo.getModalidad_semanas().equals(modalidad_id)
            ) {
                prestamosFiltrados.add(prestamo);
            }

        }

        if (!prestamosFiltrados.isEmpty()) {
            prestamosAdapter.setListaFiltrada(prestamosFiltrados);
        } else {

        }
    }

    public void getConfiguracionSemana() {
        Log.d("DEBUG", "Entro en getConfiguracionSemana()............");

        // Comprobar si el tamaño de configuracionSemanaController es mayor o igual a 0
        if (configuracionSemanaController.obtener().size() >= 0) {
            Log.d("DEBUG", "Entro en configuracionSemanaController().size() >= 0............");

            vs = VolleyS.getInstance(this.getContext());
            requestQueue = vs.getRequestQueue();

            JSONObject data = new JSONObject();
            try {
                data.put("func", "indexApp_UpdConfiguraciones");
                //Log.d("DEBUG", "Datos a enviar: " + data.toString()); // Log para verificar los datos a enviar

            } catch (JSONException e) {
                Log.d("DEBUG", "Error al crear el JSON: " + e.getMessage());
                e.printStackTrace();
            }

            JsonObjectRequest request = new JsonObjectRequest(Request.Method.POST, API.urlPrestamos, data,
                    new Response.Listener<JSONObject>() {
                        @Override
                        public void onResponse(JSONObject response) {
                            try {
                                //Log.d("DEBUG", "Entro en request SUCCESS............");
                                JSONArray data = response.getJSONArray("data"); // Cambié esto por getJSONArray()

                                //Log.d("DEBUG", "Tamaño de datos recibidos: " + data.length()); // Log para verificar el tamaño de los datos

                                for (int i = 0; i < data.length(); i++) {
                                    JSONObject obj = data.getJSONObject(i);
                                    //Log.d("DEBUG", "Objeto recibido: " + obj.toString()); // Log para verificar el objeto recibido

                                    Gson gson = new Gson();
                                    ConfiguracionSemana configuracion = gson.fromJson(obj.toString(), ConfiguracionSemana.class);
                                    configuracionSemanas.add(configuracion);
                                    configuracionSemanaController.nueva(configuracion);
                                }
                            } catch (JSONException e) {
                                Log.d("DEBUG", "Error en el procesamiento de la respuesta: " + e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    }, new Response.ErrorListener() {
                @Override
                public void onErrorResponse(VolleyError error) {
                    Log.d("DEBUG", "Entro en request ERROR getConfiguracionSemana!!!!!............");

                    // Verifica si hay una respuesta del servidor
                    if (error.networkResponse != null) {
                        // Aquí puedes obtener el código de estado HTTP
                        int statusCode = error.networkResponse.statusCode;
                        Log.d("DEBUG", "HTTP Status Code: " + statusCode);

                        // También puedes intentar obtener el cuerpo de la respuesta
                        String responseBody = new String(error.networkResponse.data);
                        Log.d("DEBUG", "Response Body: " + responseBody);
                    } else {
                        Log.d("DEBUG", "No hay respuesta del servidor.");
                    }

                    ErrorChecker.checker(error, getActivity());
                }

            });

            request.setRetryPolicy(new DefaultRetryPolicy(
                    0,
                    DefaultRetryPolicy.DEFAULT_MAX_RETRIES,
                    DefaultRetryPolicy.DEFAULT_BACKOFF_MULT));

            requestQueue.add(request);
        } else {
            Log.d("DEBUG", "No hay configuraciones disponibles en configuracionSemanaController.");
        }
    }

}